@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin

import com.pulumi.aws.emr.EmrFunctions.getReleaseLabelsPlain
import com.pulumi.aws.emr.EmrFunctions.getSupportedInstanceTypesPlain
import com.pulumi.aws.emr.kotlin.inputs.GetReleaseLabelsFilters
import com.pulumi.aws.emr.kotlin.inputs.GetReleaseLabelsPlainArgs
import com.pulumi.aws.emr.kotlin.inputs.GetReleaseLabelsPlainArgsBuilder
import com.pulumi.aws.emr.kotlin.inputs.GetSupportedInstanceTypesPlainArgs
import com.pulumi.aws.emr.kotlin.inputs.GetSupportedInstanceTypesPlainArgsBuilder
import com.pulumi.aws.emr.kotlin.inputs.GetSupportedInstanceTypesSupportedInstanceType
import com.pulumi.aws.emr.kotlin.outputs.GetReleaseLabelsResult
import com.pulumi.aws.emr.kotlin.outputs.GetSupportedInstanceTypesResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.emr.kotlin.outputs.GetReleaseLabelsResult.Companion.toKotlin as getReleaseLabelsResultToKotlin
import com.pulumi.aws.emr.kotlin.outputs.GetSupportedInstanceTypesResult.Companion.toKotlin as getSupportedInstanceTypesResultToKotlin

public object EmrFunctions {
    /**
     * Retrieve information about EMR Release Labels.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.emr.EmrFunctions;
     * import com.pulumi.aws.emr.inputs.GetReleaseLabelsArgs;
     * import com.pulumi.aws.emr.inputs.GetReleaseLabelsFiltersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EmrFunctions.getReleaseLabels(GetReleaseLabelsArgs.builder()
     *             .filters(GetReleaseLabelsFiltersArgs.builder()
     *                 .application("spark@2.1.0")
     *                 .prefix("emr-5")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getReleaseLabels.
     * @return A collection of values returned by getReleaseLabels.
     */
    public suspend fun getReleaseLabels(argument: GetReleaseLabelsPlainArgs): GetReleaseLabelsResult =
        getReleaseLabelsResultToKotlin(getReleaseLabelsPlain(argument.toJava()).await())

    /**
     * @see [getReleaseLabels].
     * @param filters Filters the results of the request. Prefix specifies the prefix of release labels to return. Application specifies the application (with/without version) of release labels to return. See Filters.
     * @return A collection of values returned by getReleaseLabels.
     */
    public suspend fun getReleaseLabels(filters: GetReleaseLabelsFilters? = null):
        GetReleaseLabelsResult {
        val argument = GetReleaseLabelsPlainArgs(
            filters = filters,
        )
        return getReleaseLabelsResultToKotlin(getReleaseLabelsPlain(argument.toJava()).await())
    }

    /**
     * @see [getReleaseLabels].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;emr&#46;kotlin&#46;inputs&#46;GetReleaseLabelsPlainArgs].
     * @return A collection of values returned by getReleaseLabels.
     */
    public suspend
    fun getReleaseLabels(argument: suspend GetReleaseLabelsPlainArgsBuilder.() -> Unit):
        GetReleaseLabelsResult {
        val builder = GetReleaseLabelsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReleaseLabelsResultToKotlin(getReleaseLabelsPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing AWS EMR Supported Instance Types.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.emr.EmrFunctions;
     * import com.pulumi.aws.emr.inputs.GetSupportedInstanceTypesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EmrFunctions.getSupportedInstanceTypes(GetSupportedInstanceTypesArgs.builder()
     *             .releaseLabel("ebs-6.15.0")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getSupportedInstanceTypes.
     * @return A collection of values returned by getSupportedInstanceTypes.
     */
    public suspend fun getSupportedInstanceTypes(argument: GetSupportedInstanceTypesPlainArgs):
        GetSupportedInstanceTypesResult =
        getSupportedInstanceTypesResultToKotlin(getSupportedInstanceTypesPlain(argument.toJava()).await())

    /**
     * @see [getSupportedInstanceTypes].
     * @param releaseLabel Amazon EMR release label. For more information about Amazon EMR releases and their included application versions and features, see the [Amazon EMR Release Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html).
     * @param supportedInstanceTypes List of supported instance types. See `supported_instance_types` below.
     * @return A collection of values returned by getSupportedInstanceTypes.
     */
    public suspend fun getSupportedInstanceTypes(
        releaseLabel: String,
        supportedInstanceTypes: List<GetSupportedInstanceTypesSupportedInstanceType>? = null,
    ):
        GetSupportedInstanceTypesResult {
        val argument = GetSupportedInstanceTypesPlainArgs(
            releaseLabel = releaseLabel,
            supportedInstanceTypes = supportedInstanceTypes,
        )
        return getSupportedInstanceTypesResultToKotlin(getSupportedInstanceTypesPlain(argument.toJava()).await())
    }

    /**
     * @see [getSupportedInstanceTypes].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;emr&#46;kotlin&#46;inputs&#46;GetSupportedInstanceTypesPlainArgs].
     * @return A collection of values returned by getSupportedInstanceTypes.
     */
    public suspend
    fun getSupportedInstanceTypes(argument: suspend GetSupportedInstanceTypesPlainArgsBuilder.() -> Unit):
        GetSupportedInstanceTypesResult {
        val builder = GetSupportedInstanceTypesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSupportedInstanceTypesResultToKotlin(getSupportedInstanceTypesPlain(builtArgument.toJava()).await())
    }
}
