@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin

import com.pulumi.aws.emr.kotlin.outputs.InstanceFleetInstanceTypeConfig
import com.pulumi.aws.emr.kotlin.outputs.InstanceFleetLaunchSpecifications
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.emr.kotlin.outputs.InstanceFleetInstanceTypeConfig.Companion.toKotlin as instanceFleetInstanceTypeConfigToKotlin
import com.pulumi.aws.emr.kotlin.outputs.InstanceFleetLaunchSpecifications.Companion.toKotlin as instanceFleetLaunchSpecificationsToKotlin

/**
 * Builder for [InstanceFleet].
 */
@PulumiTagMarker
public class InstanceFleetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceFleetArgs = InstanceFleetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceFleetArgsBuilder.() -> Unit) {
        val builder = InstanceFleetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): InstanceFleet {
        val builtJavaResource = com.pulumi.aws.emr.InstanceFleet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InstanceFleet(builtJavaResource)
    }
}

/**
 * Provides an Elastic MapReduce Cluster Instance Fleet configuration.
 * See [Amazon Elastic MapReduce Documentation](https://aws.amazon.com/documentation/emr/) for more information.
 * > **NOTE:** At this time, Instance Fleets cannot be destroyed through the API nor
 * web interface. Instance Fleets are destroyed when the EMR Cluster is destroyed.
 * the provider will resize any Instance Fleet to zero when destroying the resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.InstanceFleet;
 * import com.pulumi.aws.emr.InstanceFleetArgs;
 * import com.pulumi.aws.emr.inputs.InstanceFleetInstanceTypeConfigArgs;
 * import com.pulumi.aws.emr.inputs.InstanceFleetLaunchSpecificationsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var task = new InstanceFleet("task", InstanceFleetArgs.builder()
 *             .clusterId(aws_emr_cluster.cluster().id())
 *             .instanceTypeConfigs(
 *                 InstanceFleetInstanceTypeConfigArgs.builder()
 *                     .bidPriceAsPercentageOfOnDemandPrice(100)
 *                     .ebsConfigs(InstanceFleetInstanceTypeConfigEbsConfigArgs.builder()
 *                         .size(100)
 *                         .type("gp2")
 *                         .volumesPerInstance(1)
 *                         .build())
 *                     .instanceType("m4.xlarge")
 *                     .weightedCapacity(1)
 *                     .build(),
 *                 InstanceFleetInstanceTypeConfigArgs.builder()
 *                     .bidPriceAsPercentageOfOnDemandPrice(100)
 *                     .ebsConfigs(InstanceFleetInstanceTypeConfigEbsConfigArgs.builder()
 *                         .size(100)
 *                         .type("gp2")
 *                         .volumesPerInstance(1)
 *                         .build())
 *                     .instanceType("m4.2xlarge")
 *                     .weightedCapacity(2)
 *                     .build())
 *             .launchSpecifications(InstanceFleetLaunchSpecificationsArgs.builder()
 *                 .spotSpecifications(InstanceFleetLaunchSpecificationsSpotSpecificationArgs.builder()
 *                     .allocationStrategy("capacity-optimized")
 *                     .blockDurationMinutes(0)
 *                     .timeoutAction("TERMINATE_CLUSTER")
 *                     .timeoutDurationMinutes(10)
 *                     .build())
 *                 .build())
 *             .targetOnDemandCapacity(1)
 *             .targetSpotCapacity(1)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EMR Instance Fleet using the EMR Cluster identifier and Instance Fleet identifier separated by a forward slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:emr/instanceFleet:InstanceFleet example j-123456ABCDEF/if-15EK4O09RZLNR
 * ```
 *
 */
public class InstanceFleet internal constructor(
    override val javaResource: com.pulumi.aws.emr.InstanceFleet,
) : KotlinCustomResource(javaResource, InstanceFleetMapper) {
    /**
     * ID of the EMR Cluster to attach to. Changing this forces a new resource to be created.
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    /**
     * Configuration block for instance fleet
     */
    public val instanceTypeConfigs: Output<List<InstanceFleetInstanceTypeConfig>>?
        get() = javaResource.instanceTypeConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        instanceFleetInstanceTypeConfigToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Configuration block for launch specification
     */
    public val launchSpecifications: Output<InstanceFleetLaunchSpecifications>?
        get() = javaResource.launchSpecifications().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> instanceFleetLaunchSpecificationsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Friendly name given to the instance fleet.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The number of On-Demand units that have been provisioned for the instance
     * fleet to fulfill TargetOnDemandCapacity. This provisioned capacity might be less than or greater than TargetOnDemandCapacity.
     */
    public val provisionedOnDemandCapacity: Output<Int>
        get() = javaResource.provisionedOnDemandCapacity().applyValue({ args0 -> args0 })

    /**
     * The number of Spot units that have been provisioned for this instance fleet
     * to fulfill TargetSpotCapacity. This provisioned capacity might be less than or greater than TargetSpotCapacity.
     */
    public val provisionedSpotCapacity: Output<Int>
        get() = javaResource.provisionedSpotCapacity().applyValue({ args0 -> args0 })

    /**
     * The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
     */
    public val targetOnDemandCapacity: Output<Int>?
        get() = javaResource.targetOnDemandCapacity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
     */
    public val targetSpotCapacity: Output<Int>?
        get() = javaResource.targetSpotCapacity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object InstanceFleetMapper : ResourceMapper<InstanceFleet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.emr.InstanceFleet::class == javaResource::class

    override fun map(javaResource: Resource): InstanceFleet = InstanceFleet(
        javaResource as
            com.pulumi.aws.emr.InstanceFleet,
    )
}

/**
 * @see [InstanceFleet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InstanceFleet].
 */
public suspend fun instanceFleet(
    name: String,
    block: suspend InstanceFleetResourceBuilder.() -> Unit,
): InstanceFleet {
    val builder = InstanceFleetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InstanceFleet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instanceFleet(name: String): InstanceFleet {
    val builder = InstanceFleetResourceBuilder()
    builder.name(name)
    return builder.build()
}
