@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin

import com.pulumi.aws.emr.InstanceFleetArgs.builder
import com.pulumi.aws.emr.kotlin.inputs.InstanceFleetInstanceTypeConfigArgs
import com.pulumi.aws.emr.kotlin.inputs.InstanceFleetInstanceTypeConfigArgsBuilder
import com.pulumi.aws.emr.kotlin.inputs.InstanceFleetLaunchSpecificationsArgs
import com.pulumi.aws.emr.kotlin.inputs.InstanceFleetLaunchSpecificationsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an Elastic MapReduce Cluster Instance Fleet configuration.
 * See [Amazon Elastic MapReduce Documentation](https://aws.amazon.com/documentation/emr/) for more information.
 * > **NOTE:** At this time, Instance Fleets cannot be destroyed through the API nor
 * web interface. Instance Fleets are destroyed when the EMR Cluster is destroyed.
 * the provider will resize any Instance Fleet to zero when destroying the resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.InstanceFleet;
 * import com.pulumi.aws.emr.InstanceFleetArgs;
 * import com.pulumi.aws.emr.inputs.InstanceFleetInstanceTypeConfigArgs;
 * import com.pulumi.aws.emr.inputs.InstanceFleetLaunchSpecificationsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var task = new InstanceFleet("task", InstanceFleetArgs.builder()
 *             .clusterId(aws_emr_cluster.cluster().id())
 *             .instanceTypeConfigs(
 *                 InstanceFleetInstanceTypeConfigArgs.builder()
 *                     .bidPriceAsPercentageOfOnDemandPrice(100)
 *                     .ebsConfigs(InstanceFleetInstanceTypeConfigEbsConfigArgs.builder()
 *                         .size(100)
 *                         .type("gp2")
 *                         .volumesPerInstance(1)
 *                         .build())
 *                     .instanceType("m4.xlarge")
 *                     .weightedCapacity(1)
 *                     .build(),
 *                 InstanceFleetInstanceTypeConfigArgs.builder()
 *                     .bidPriceAsPercentageOfOnDemandPrice(100)
 *                     .ebsConfigs(InstanceFleetInstanceTypeConfigEbsConfigArgs.builder()
 *                         .size(100)
 *                         .type("gp2")
 *                         .volumesPerInstance(1)
 *                         .build())
 *                     .instanceType("m4.2xlarge")
 *                     .weightedCapacity(2)
 *                     .build())
 *             .launchSpecifications(InstanceFleetLaunchSpecificationsArgs.builder()
 *                 .spotSpecifications(InstanceFleetLaunchSpecificationsSpotSpecificationArgs.builder()
 *                     .allocationStrategy("capacity-optimized")
 *                     .blockDurationMinutes(0)
 *                     .timeoutAction("TERMINATE_CLUSTER")
 *                     .timeoutDurationMinutes(10)
 *                     .build())
 *                 .build())
 *             .targetOnDemandCapacity(1)
 *             .targetSpotCapacity(1)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EMR Instance Fleet using the EMR Cluster identifier and Instance Fleet identifier separated by a forward slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:emr/instanceFleet:InstanceFleet example j-123456ABCDEF/if-15EK4O09RZLNR
 * ```
 * @property clusterId ID of the EMR Cluster to attach to. Changing this forces a new resource to be created.
 * @property instanceTypeConfigs Configuration block for instance fleet
 * @property launchSpecifications Configuration block for launch specification
 * @property name Friendly name given to the instance fleet.
 * @property targetOnDemandCapacity The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
 * @property targetSpotCapacity The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
 */
public data class InstanceFleetArgs(
    public val clusterId: Output<String>? = null,
    public val instanceTypeConfigs: Output<List<InstanceFleetInstanceTypeConfigArgs>>? = null,
    public val launchSpecifications: Output<InstanceFleetLaunchSpecificationsArgs>? = null,
    public val name: Output<String>? = null,
    public val targetOnDemandCapacity: Output<Int>? = null,
    public val targetSpotCapacity: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.InstanceFleetArgs> {
    override fun toJava(): com.pulumi.aws.emr.InstanceFleetArgs =
        com.pulumi.aws.emr.InstanceFleetArgs.builder()
            .clusterId(clusterId?.applyValue({ args0 -> args0 }))
            .instanceTypeConfigs(
                instanceTypeConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .launchSpecifications(
                launchSpecifications?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .targetOnDemandCapacity(targetOnDemandCapacity?.applyValue({ args0 -> args0 }))
            .targetSpotCapacity(targetSpotCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceFleetArgs].
 */
@PulumiTagMarker
public class InstanceFleetArgsBuilder internal constructor() {
    private var clusterId: Output<String>? = null

    private var instanceTypeConfigs: Output<List<InstanceFleetInstanceTypeConfigArgs>>? = null

    private var launchSpecifications: Output<InstanceFleetLaunchSpecificationsArgs>? = null

    private var name: Output<String>? = null

    private var targetOnDemandCapacity: Output<Int>? = null

    private var targetSpotCapacity: Output<Int>? = null

    /**
     * @param value ID of the EMR Cluster to attach to. Changing this forces a new resource to be created.
     */
    @JvmName("twwunvvciuncwbwh")
    public suspend fun clusterId(`value`: Output<String>) {
        this.clusterId = value
    }

    /**
     * @param value Configuration block for instance fleet
     */
    @JvmName("yvgkinkgdftbaqhy")
    public suspend
    fun instanceTypeConfigs(`value`: Output<List<InstanceFleetInstanceTypeConfigArgs>>) {
        this.instanceTypeConfigs = value
    }

    @JvmName("njgdkggkocveglry")
    public suspend fun instanceTypeConfigs(
        vararg
        values: Output<InstanceFleetInstanceTypeConfigArgs>,
    ) {
        this.instanceTypeConfigs = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for instance fleet
     */
    @JvmName("jownlioifiuydkds")
    public suspend
    fun instanceTypeConfigs(values: List<Output<InstanceFleetInstanceTypeConfigArgs>>) {
        this.instanceTypeConfigs = Output.all(values)
    }

    /**
     * @param value Configuration block for launch specification
     */
    @JvmName("qjsrknmdqqlidtvl")
    public suspend fun launchSpecifications(`value`: Output<InstanceFleetLaunchSpecificationsArgs>) {
        this.launchSpecifications = value
    }

    /**
     * @param value Friendly name given to the instance fleet.
     */
    @JvmName("snaeaugjpuleakco")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
     */
    @JvmName("xsyxnbkuhlpgmasi")
    public suspend fun targetOnDemandCapacity(`value`: Output<Int>) {
        this.targetOnDemandCapacity = value
    }

    /**
     * @param value The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
     */
    @JvmName("aecgfgtcaokhnvhe")
    public suspend fun targetSpotCapacity(`value`: Output<Int>) {
        this.targetSpotCapacity = value
    }

    /**
     * @param value ID of the EMR Cluster to attach to. Changing this forces a new resource to be created.
     */
    @JvmName("wufdegmtrqvofcdh")
    public suspend fun clusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterId = mapped
    }

    /**
     * @param value Configuration block for instance fleet
     */
    @JvmName("vgpdefxmjfibkllw")
    public suspend fun instanceTypeConfigs(`value`: List<InstanceFleetInstanceTypeConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceTypeConfigs = mapped
    }

    /**
     * @param argument Configuration block for instance fleet
     */
    @JvmName("rivbcnnesmggbrjw")
    public suspend
    fun instanceTypeConfigs(argument: List<suspend InstanceFleetInstanceTypeConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceFleetInstanceTypeConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.instanceTypeConfigs = mapped
    }

    /**
     * @param argument Configuration block for instance fleet
     */
    @JvmName("kjkcvfdkbomxlwgc")
    public suspend fun instanceTypeConfigs(
        vararg
        argument: suspend InstanceFleetInstanceTypeConfigArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            InstanceFleetInstanceTypeConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.instanceTypeConfigs = mapped
    }

    /**
     * @param argument Configuration block for instance fleet
     */
    @JvmName("rxmifbmvldccidur")
    public suspend
    fun instanceTypeConfigs(argument: suspend InstanceFleetInstanceTypeConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InstanceFleetInstanceTypeConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.instanceTypeConfigs = mapped
    }

    /**
     * @param values Configuration block for instance fleet
     */
    @JvmName("makrdwccbokfosvp")
    public suspend fun instanceTypeConfigs(vararg values: InstanceFleetInstanceTypeConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceTypeConfigs = mapped
    }

    /**
     * @param value Configuration block for launch specification
     */
    @JvmName("rxbjceuewvfdyfli")
    public suspend fun launchSpecifications(`value`: InstanceFleetLaunchSpecificationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchSpecifications = mapped
    }

    /**
     * @param argument Configuration block for launch specification
     */
    @JvmName("cvbeeybujwumykav")
    public suspend
    fun launchSpecifications(argument: suspend InstanceFleetLaunchSpecificationsArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceFleetLaunchSpecificationsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.launchSpecifications = mapped
    }

    /**
     * @param value Friendly name given to the instance fleet.
     */
    @JvmName("qdrrqjlrwtwokhna")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
     */
    @JvmName("ltnybpahmthruvdo")
    public suspend fun targetOnDemandCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetOnDemandCapacity = mapped
    }

    /**
     * @param value The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
     */
    @JvmName("wgktaoflpymnrblt")
    public suspend fun targetSpotCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetSpotCapacity = mapped
    }

    internal fun build(): InstanceFleetArgs = InstanceFleetArgs(
        clusterId = clusterId,
        instanceTypeConfigs = instanceTypeConfigs,
        launchSpecifications = launchSpecifications,
        name = name,
        targetOnDemandCapacity = targetOnDemandCapacity,
        targetSpotCapacity = targetSpotCapacity,
    )
}
