@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin

import com.pulumi.aws.emr.kotlin.outputs.ManagedScalingPolicyComputeLimit
import com.pulumi.aws.emr.kotlin.outputs.ManagedScalingPolicyComputeLimit.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ManagedScalingPolicy].
 */
@PulumiTagMarker
public class ManagedScalingPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedScalingPolicyArgs = ManagedScalingPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedScalingPolicyArgsBuilder.() -> Unit) {
        val builder = ManagedScalingPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ManagedScalingPolicy {
        val builtJavaResource = com.pulumi.aws.emr.ManagedScalingPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ManagedScalingPolicy(builtJavaResource)
    }
}

/**
 * Provides a Managed Scaling policy for EMR Cluster. With Amazon EMR versions 5.30.0 and later (except for Amazon EMR 6.0.0), you can enable EMR managed scaling to automatically increase or decrease the number of instances or units in your cluster based on workload. See [Using EMR Managed Scaling in Amazon EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-scaling.html) for more information.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.Cluster;
 * import com.pulumi.aws.emr.ClusterArgs;
 * import com.pulumi.aws.emr.inputs.ClusterMasterInstanceGroupArgs;
 * import com.pulumi.aws.emr.inputs.ClusterCoreInstanceGroupArgs;
 * import com.pulumi.aws.emr.ManagedScalingPolicy;
 * import com.pulumi.aws.emr.ManagedScalingPolicyArgs;
 * import com.pulumi.aws.emr.inputs.ManagedScalingPolicyComputeLimitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sample = new Cluster("sample", ClusterArgs.builder()
 *             .releaseLabel("emr-5.30.0")
 *             .masterInstanceGroup(ClusterMasterInstanceGroupArgs.builder()
 *                 .instanceType("m4.large")
 *                 .build())
 *             .coreInstanceGroup(ClusterCoreInstanceGroupArgs.builder()
 *                 .instanceType("c4.large")
 *                 .build())
 *             .build());
 *         var samplepolicy = new ManagedScalingPolicy("samplepolicy", ManagedScalingPolicyArgs.builder()
 *             .clusterId(sample.id())
 *             .computeLimits(ManagedScalingPolicyComputeLimitArgs.builder()
 *                 .unitType("Instances")
 *                 .minimumCapacityUnits(2)
 *                 .maximumCapacityUnits(10)
 *                 .maximumOndemandCapacityUnits(2)
 *                 .maximumCoreCapacityUnits(10)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EMR Managed Scaling Policies using the EMR Cluster identifier. For example:
 * ```sh
 *  $ pulumi import aws:emr/managedScalingPolicy:ManagedScalingPolicy example j-123456ABCDEF
 * ```
 *
 */
public class ManagedScalingPolicy internal constructor(
    override val javaResource: com.pulumi.aws.emr.ManagedScalingPolicy,
) : KotlinCustomResource(javaResource, ManagedScalingPolicyMapper) {
    /**
     * ID of the EMR cluster
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    /**
     * Configuration block with compute limit settings. Described below.
     */
    public val computeLimits: Output<List<ManagedScalingPolicyComputeLimit>>
        get() = javaResource.computeLimits().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })
}

public object ManagedScalingPolicyMapper : ResourceMapper<ManagedScalingPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.emr.ManagedScalingPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ManagedScalingPolicy = ManagedScalingPolicy(
        javaResource
            as com.pulumi.aws.emr.ManagedScalingPolicy,
    )
}

/**
 * @see [ManagedScalingPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedScalingPolicy].
 */
public suspend fun managedScalingPolicy(
    name: String,
    block: suspend ManagedScalingPolicyResourceBuilder.() -> Unit,
): ManagedScalingPolicy {
    val builder = ManagedScalingPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedScalingPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedScalingPolicy(name: String): ManagedScalingPolicy {
    val builder = ManagedScalingPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
