@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin

import com.pulumi.aws.emr.ManagedScalingPolicyArgs.builder
import com.pulumi.aws.emr.kotlin.inputs.ManagedScalingPolicyComputeLimitArgs
import com.pulumi.aws.emr.kotlin.inputs.ManagedScalingPolicyComputeLimitArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Managed Scaling policy for EMR Cluster. With Amazon EMR versions 5.30.0 and later (except for Amazon EMR 6.0.0), you can enable EMR managed scaling to automatically increase or decrease the number of instances or units in your cluster based on workload. See [Using EMR Managed Scaling in Amazon EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-scaling.html) for more information.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.Cluster;
 * import com.pulumi.aws.emr.ClusterArgs;
 * import com.pulumi.aws.emr.inputs.ClusterMasterInstanceGroupArgs;
 * import com.pulumi.aws.emr.inputs.ClusterCoreInstanceGroupArgs;
 * import com.pulumi.aws.emr.ManagedScalingPolicy;
 * import com.pulumi.aws.emr.ManagedScalingPolicyArgs;
 * import com.pulumi.aws.emr.inputs.ManagedScalingPolicyComputeLimitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sample = new Cluster("sample", ClusterArgs.builder()
 *             .releaseLabel("emr-5.30.0")
 *             .masterInstanceGroup(ClusterMasterInstanceGroupArgs.builder()
 *                 .instanceType("m4.large")
 *                 .build())
 *             .coreInstanceGroup(ClusterCoreInstanceGroupArgs.builder()
 *                 .instanceType("c4.large")
 *                 .build())
 *             .build());
 *         var samplepolicy = new ManagedScalingPolicy("samplepolicy", ManagedScalingPolicyArgs.builder()
 *             .clusterId(sample.id())
 *             .computeLimits(ManagedScalingPolicyComputeLimitArgs.builder()
 *                 .unitType("Instances")
 *                 .minimumCapacityUnits(2)
 *                 .maximumCapacityUnits(10)
 *                 .maximumOndemandCapacityUnits(2)
 *                 .maximumCoreCapacityUnits(10)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EMR Managed Scaling Policies using the EMR Cluster identifier. For example:
 * ```sh
 *  $ pulumi import aws:emr/managedScalingPolicy:ManagedScalingPolicy example j-123456ABCDEF
 * ```
 * @property clusterId ID of the EMR cluster
 * @property computeLimits Configuration block with compute limit settings. Described below.
 */
public data class ManagedScalingPolicyArgs(
    public val clusterId: Output<String>? = null,
    public val computeLimits: Output<List<ManagedScalingPolicyComputeLimitArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.ManagedScalingPolicyArgs> {
    override fun toJava(): com.pulumi.aws.emr.ManagedScalingPolicyArgs =
        com.pulumi.aws.emr.ManagedScalingPolicyArgs.builder()
            .clusterId(clusterId?.applyValue({ args0 -> args0 }))
            .computeLimits(
                computeLimits?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedScalingPolicyArgs].
 */
@PulumiTagMarker
public class ManagedScalingPolicyArgsBuilder internal constructor() {
    private var clusterId: Output<String>? = null

    private var computeLimits: Output<List<ManagedScalingPolicyComputeLimitArgs>>? = null

    /**
     * @param value ID of the EMR cluster
     */
    @JvmName("uqjkuvaljbcaofod")
    public suspend fun clusterId(`value`: Output<String>) {
        this.clusterId = value
    }

    /**
     * @param value Configuration block with compute limit settings. Described below.
     */
    @JvmName("ehdtjarooitdpiin")
    public suspend fun computeLimits(`value`: Output<List<ManagedScalingPolicyComputeLimitArgs>>) {
        this.computeLimits = value
    }

    @JvmName("makupmwaaycylfhx")
    public suspend fun computeLimits(vararg values: Output<ManagedScalingPolicyComputeLimitArgs>) {
        this.computeLimits = Output.all(values.asList())
    }

    /**
     * @param values Configuration block with compute limit settings. Described below.
     */
    @JvmName("yfltkkscsutgebkc")
    public suspend fun computeLimits(values: List<Output<ManagedScalingPolicyComputeLimitArgs>>) {
        this.computeLimits = Output.all(values)
    }

    /**
     * @param value ID of the EMR cluster
     */
    @JvmName("rdqficwxpluowymp")
    public suspend fun clusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterId = mapped
    }

    /**
     * @param value Configuration block with compute limit settings. Described below.
     */
    @JvmName("rsikuvriisxnpamx")
    public suspend fun computeLimits(`value`: List<ManagedScalingPolicyComputeLimitArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeLimits = mapped
    }

    /**
     * @param argument Configuration block with compute limit settings. Described below.
     */
    @JvmName("hyojfcuwlsaqhvpy")
    public suspend
    fun computeLimits(argument: List<suspend ManagedScalingPolicyComputeLimitArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ManagedScalingPolicyComputeLimitArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.computeLimits = mapped
    }

    /**
     * @param argument Configuration block with compute limit settings. Described below.
     */
    @JvmName("akdyupnotfdlxrmu")
    public suspend fun computeLimits(
        vararg
        argument: suspend ManagedScalingPolicyComputeLimitArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ManagedScalingPolicyComputeLimitArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.computeLimits = mapped
    }

    /**
     * @param argument Configuration block with compute limit settings. Described below.
     */
    @JvmName("koudtpbyfipimacn")
    public suspend
    fun computeLimits(argument: suspend ManagedScalingPolicyComputeLimitArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ManagedScalingPolicyComputeLimitArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.computeLimits = mapped
    }

    /**
     * @param values Configuration block with compute limit settings. Described below.
     */
    @JvmName("pynnwpdurtcogtwy")
    public suspend fun computeLimits(vararg values: ManagedScalingPolicyComputeLimitArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.computeLimits = mapped
    }

    internal fun build(): ManagedScalingPolicyArgs = ManagedScalingPolicyArgs(
        clusterId = clusterId,
        computeLimits = computeLimits,
    )
}
