@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SecurityConfiguration].
 */
@PulumiTagMarker
public class SecurityConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecurityConfigurationArgs = SecurityConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecurityConfigurationArgsBuilder.() -> Unit) {
        val builder = SecurityConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SecurityConfiguration {
        val builtJavaResource = com.pulumi.aws.emr.SecurityConfiguration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SecurityConfiguration(builtJavaResource)
    }
}

/**
 * Provides a resource to manage AWS EMR Security Configurations
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.SecurityConfiguration;
 * import com.pulumi.aws.emr.SecurityConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new SecurityConfiguration("foo", SecurityConfigurationArgs.builder()
 *             .configuration("""
 * {
 *   "EncryptionConfiguration": {
 *     "AtRestEncryptionConfiguration": {
 *       "S3EncryptionConfiguration": {
 *         "EncryptionMode": "SSE-S3"
 *       },
 *       "LocalDiskEncryptionConfiguration": {
 *         "EncryptionKeyProviderType": "AwsKms",
 *         "AwsKmsKey": "arn:aws:kms:us-west-2:187416307283:alias/my_emr_test_key"
 *       }
 *     },
 *     "EnableInTransitEncryption": false,
 *     "EnableAtRestEncryption": true
 *   }
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EMR Security Configurations using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:emr/securityConfiguration:SecurityConfiguration sc example-sc-name
 * ```
 *
 */
public class SecurityConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.emr.SecurityConfiguration,
) : KotlinCustomResource(javaResource, SecurityConfigurationMapper) {
    /**
     * A JSON formatted Security Configuration
     */
    public val configuration: Output<String>
        get() = javaResource.configuration().applyValue({ args0 -> args0 })

    /**
     * Date the Security Configuration was created
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * The name of the EMR Security Configuration. By default generated by this provider.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })
}

public object SecurityConfigurationMapper : ResourceMapper<SecurityConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.emr.SecurityConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): SecurityConfiguration =
        SecurityConfiguration(javaResource as com.pulumi.aws.emr.SecurityConfiguration)
}

/**
 * @see [SecurityConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecurityConfiguration].
 */
public suspend fun securityConfiguration(
    name: String,
    block: suspend SecurityConfigurationResourceBuilder.() -> Unit,
): SecurityConfiguration {
    val builder = SecurityConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecurityConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securityConfiguration(name: String): SecurityConfiguration {
    val builder = SecurityConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
