@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin

import com.pulumi.aws.emr.SecurityConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage AWS EMR Security Configurations
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.SecurityConfiguration;
 * import com.pulumi.aws.emr.SecurityConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new SecurityConfiguration("foo", SecurityConfigurationArgs.builder()
 *             .configuration("""
 * {
 *   "EncryptionConfiguration": {
 *     "AtRestEncryptionConfiguration": {
 *       "S3EncryptionConfiguration": {
 *         "EncryptionMode": "SSE-S3"
 *       },
 *       "LocalDiskEncryptionConfiguration": {
 *         "EncryptionKeyProviderType": "AwsKms",
 *         "AwsKmsKey": "arn:aws:kms:us-west-2:187416307283:alias/my_emr_test_key"
 *       }
 *     },
 *     "EnableInTransitEncryption": false,
 *     "EnableAtRestEncryption": true
 *   }
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EMR Security Configurations using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:emr/securityConfiguration:SecurityConfiguration sc example-sc-name
 * ```
 * @property configuration A JSON formatted Security Configuration
 * @property name The name of the EMR Security Configuration. By default generated by this provider.
 * @property namePrefix Creates a unique name beginning with the specified
 * prefix. Conflicts with `name`.
 */
public data class SecurityConfigurationArgs(
    public val configuration: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.SecurityConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.emr.SecurityConfigurationArgs =
        com.pulumi.aws.emr.SecurityConfigurationArgs.builder()
            .configuration(configuration?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityConfigurationArgs].
 */
@PulumiTagMarker
public class SecurityConfigurationArgsBuilder internal constructor() {
    private var configuration: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    /**
     * @param value A JSON formatted Security Configuration
     */
    @JvmName("bkinpfxjttkfksrw")
    public suspend fun configuration(`value`: Output<String>) {
        this.configuration = value
    }

    /**
     * @param value The name of the EMR Security Configuration. By default generated by this provider.
     */
    @JvmName("hipneyufeubakwqo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     */
    @JvmName("swfulpnkidvphsnm")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value A JSON formatted Security Configuration
     */
    @JvmName("jlseeppfpdtdryoj")
    public suspend fun configuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param value The name of the EMR Security Configuration. By default generated by this provider.
     */
    @JvmName("ronekdfqparcqwqx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     */
    @JvmName("hgljafoitcbnviny")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    internal fun build(): SecurityConfigurationArgs = SecurityConfigurationArgs(
        configuration = configuration,
        name = name,
        namePrefix = namePrefix,
    )
}
