@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Studio].
 */
@PulumiTagMarker
public class StudioResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StudioArgs = StudioArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StudioArgsBuilder.() -> Unit) {
        val builder = StudioArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Studio {
        val builtJavaResource = com.pulumi.aws.emr.Studio(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Studio(builtJavaResource)
    }
}

/**
 * Provides an Elastic MapReduce Studio.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.Studio;
 * import com.pulumi.aws.emr.StudioArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Studio("example", StudioArgs.builder()
 *             .authMode("SSO")
 *             .defaultS3Location(String.format("s3://%s/test", aws_s3_bucket.test().bucket()))
 *             .engineSecurityGroupId(aws_security_group.test().id())
 *             .serviceRole(aws_iam_role.test().arn())
 *             .subnetIds(aws_subnet.test().id())
 *             .userRole(aws_iam_role.test().arn())
 *             .vpcId(aws_vpc.test().id())
 *             .workspaceSecurityGroupId(aws_security_group.test().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EMR studios using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:emr/studio:Studio studio es-123456ABCDEF
 * ```
 *
 */
public class Studio internal constructor(
    override val javaResource: com.pulumi.aws.emr.Studio,
) : KotlinCustomResource(javaResource, StudioMapper) {
    /**
     * ARN of the studio.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO. Valid values are `SSO` or `IAM`.
     */
    public val authMode: Output<String>
        get() = javaResource.authMode().applyValue({ args0 -> args0 })

    /**
     * The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
     */
    public val defaultS3Location: Output<String>
        get() = javaResource.defaultS3Location().applyValue({ args0 -> args0 })

    /**
     * A detailed description of the Amazon EMR Studio.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by `vpc_id`.
     */
    public val engineSecurityGroupId: Output<String>
        get() = javaResource.engineSecurityGroupId().applyValue({ args0 -> args0 })

    /**
     * The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.
     */
    public val idpAuthUrl: Output<String>?
        get() = javaResource.idpAuthUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name that your identity provider (IdP) uses for its RelayState parameter. For example, RelayState or TargetSource. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The RelayState parameter differs by IdP.
     */
    public val idpRelayStateParameterName: Output<String>?
        get() = javaResource.idpRelayStateParameterName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A descriptive name for the Amazon EMR Studio.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to interoperate with other Amazon Web Services services.
     */
    public val serviceRole: Output<String>
        get() = javaResource.serviceRole().applyValue({ args0 -> args0 })

    /**
     * A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by `vpc_id`. Studio users can create a Workspace in any of the specified subnets.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The unique access URL of the Amazon EMR Studio.
     */
    public val url: Output<String>
        get() = javaResource.url().applyValue({ args0 -> args0 })

    /**
     * The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a User Role when you use Amazon Web Services SSO authentication. The permissions attached to the User Role can be scoped down for each user or group using session policies.
     */
    public val userRole: Output<String>?
        get() = javaResource.userRole().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound network traffic to resources in the Engine security group, and it must be in the same VPC specified by `vpc_id`.
     * The following arguments are optional:
     */
    public val workspaceSecurityGroupId: Output<String>
        get() = javaResource.workspaceSecurityGroupId().applyValue({ args0 -> args0 })
}

public object StudioMapper : ResourceMapper<Studio> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.emr.Studio::class == javaResource::class

    override fun map(javaResource: Resource): Studio = Studio(
        javaResource as
            com.pulumi.aws.emr.Studio,
    )
}

/**
 * @see [Studio].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Studio].
 */
public suspend fun studio(name: String, block: suspend StudioResourceBuilder.() -> Unit): Studio {
    val builder = StudioResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Studio].
 * @param name The _unique_ name of the resulting resource.
 */
public fun studio(name: String): Studio {
    val builder = StudioResourceBuilder()
    builder.name(name)
    return builder.build()
}
