@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin

import com.pulumi.aws.emr.StudioArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Elastic MapReduce Studio.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.Studio;
 * import com.pulumi.aws.emr.StudioArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Studio("example", StudioArgs.builder()
 *             .authMode("SSO")
 *             .defaultS3Location(String.format("s3://%s/test", aws_s3_bucket.test().bucket()))
 *             .engineSecurityGroupId(aws_security_group.test().id())
 *             .serviceRole(aws_iam_role.test().arn())
 *             .subnetIds(aws_subnet.test().id())
 *             .userRole(aws_iam_role.test().arn())
 *             .vpcId(aws_vpc.test().id())
 *             .workspaceSecurityGroupId(aws_security_group.test().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EMR studios using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:emr/studio:Studio studio es-123456ABCDEF
 * ```
 * @property authMode Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO. Valid values are `SSO` or `IAM`.
 * @property defaultS3Location The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
 * @property description A detailed description of the Amazon EMR Studio.
 * @property engineSecurityGroupId The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by `vpc_id`.
 * @property idpAuthUrl The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.
 * @property idpRelayStateParameterName The name that your identity provider (IdP) uses for its RelayState parameter. For example, RelayState or TargetSource. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The RelayState parameter differs by IdP.
 * @property name A descriptive name for the Amazon EMR Studio.
 * @property serviceRole The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to interoperate with other Amazon Web Services services.
 * @property subnetIds A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by `vpc_id`. Studio users can create a Workspace in any of the specified subnets.
 * @property tags list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property userRole The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a User Role when you use Amazon Web Services SSO authentication. The permissions attached to the User Role can be scoped down for each user or group using session policies.
 * @property vpcId The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.
 * @property workspaceSecurityGroupId The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound network traffic to resources in the Engine security group, and it must be in the same VPC specified by `vpc_id`.
 * The following arguments are optional:
 */
public data class StudioArgs(
    public val authMode: Output<String>? = null,
    public val defaultS3Location: Output<String>? = null,
    public val description: Output<String>? = null,
    public val engineSecurityGroupId: Output<String>? = null,
    public val idpAuthUrl: Output<String>? = null,
    public val idpRelayStateParameterName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val serviceRole: Output<String>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userRole: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val workspaceSecurityGroupId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.StudioArgs> {
    override fun toJava(): com.pulumi.aws.emr.StudioArgs = com.pulumi.aws.emr.StudioArgs.builder()
        .authMode(authMode?.applyValue({ args0 -> args0 }))
        .defaultS3Location(defaultS3Location?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .engineSecurityGroupId(engineSecurityGroupId?.applyValue({ args0 -> args0 }))
        .idpAuthUrl(idpAuthUrl?.applyValue({ args0 -> args0 }))
        .idpRelayStateParameterName(idpRelayStateParameterName?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .serviceRole(serviceRole?.applyValue({ args0 -> args0 }))
        .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .userRole(userRole?.applyValue({ args0 -> args0 }))
        .vpcId(vpcId?.applyValue({ args0 -> args0 }))
        .workspaceSecurityGroupId(workspaceSecurityGroupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StudioArgs].
 */
@PulumiTagMarker
public class StudioArgsBuilder internal constructor() {
    private var authMode: Output<String>? = null

    private var defaultS3Location: Output<String>? = null

    private var description: Output<String>? = null

    private var engineSecurityGroupId: Output<String>? = null

    private var idpAuthUrl: Output<String>? = null

    private var idpRelayStateParameterName: Output<String>? = null

    private var name: Output<String>? = null

    private var serviceRole: Output<String>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userRole: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var workspaceSecurityGroupId: Output<String>? = null

    /**
     * @param value Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO. Valid values are `SSO` or `IAM`.
     */
    @JvmName("gqrymyfupcmuevgs")
    public suspend fun authMode(`value`: Output<String>) {
        this.authMode = value
    }

    /**
     * @param value The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
     */
    @JvmName("kpaypmxcklfgvcxu")
    public suspend fun defaultS3Location(`value`: Output<String>) {
        this.defaultS3Location = value
    }

    /**
     * @param value A detailed description of the Amazon EMR Studio.
     */
    @JvmName("xcipwmwltcojladq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by `vpc_id`.
     */
    @JvmName("eeslbjngdjbffrop")
    public suspend fun engineSecurityGroupId(`value`: Output<String>) {
        this.engineSecurityGroupId = value
    }

    /**
     * @param value The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.
     */
    @JvmName("ecidlyuniorhrlhn")
    public suspend fun idpAuthUrl(`value`: Output<String>) {
        this.idpAuthUrl = value
    }

    /**
     * @param value The name that your identity provider (IdP) uses for its RelayState parameter. For example, RelayState or TargetSource. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The RelayState parameter differs by IdP.
     */
    @JvmName("bfkgnwxwinteinje")
    public suspend fun idpRelayStateParameterName(`value`: Output<String>) {
        this.idpRelayStateParameterName = value
    }

    /**
     * @param value A descriptive name for the Amazon EMR Studio.
     */
    @JvmName("koruhvtllgtkqcpo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to interoperate with other Amazon Web Services services.
     */
    @JvmName("fqygtrnwxhfguhtn")
    public suspend fun serviceRole(`value`: Output<String>) {
        this.serviceRole = value
    }

    /**
     * @param value A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by `vpc_id`. Studio users can create a Workspace in any of the specified subnets.
     */
    @JvmName("tggfskiaybsitsto")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("ejpdggkqmnumtehu")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by `vpc_id`. Studio users can create a Workspace in any of the specified subnets.
     */
    @JvmName("agbgwfywbenbweqo")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ghhygqxscknlieyx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a User Role when you use Amazon Web Services SSO authentication. The permissions attached to the User Role can be scoped down for each user or group using session policies.
     */
    @JvmName("wwekwxfuaiixpaxk")
    public suspend fun userRole(`value`: Output<String>) {
        this.userRole = value
    }

    /**
     * @param value The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.
     */
    @JvmName("cgvsjnplbashqnum")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound network traffic to resources in the Engine security group, and it must be in the same VPC specified by `vpc_id`.
     * The following arguments are optional:
     */
    @JvmName("ahsgwevtuonnmvbe")
    public suspend fun workspaceSecurityGroupId(`value`: Output<String>) {
        this.workspaceSecurityGroupId = value
    }

    /**
     * @param value Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO. Valid values are `SSO` or `IAM`.
     */
    @JvmName("oltjdaxupioasnsm")
    public suspend fun authMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authMode = mapped
    }

    /**
     * @param value The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
     */
    @JvmName("xtjoshyggchvvvmt")
    public suspend fun defaultS3Location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultS3Location = mapped
    }

    /**
     * @param value A detailed description of the Amazon EMR Studio.
     */
    @JvmName("cosxpyyboxdwgujy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by `vpc_id`.
     */
    @JvmName("mwbbcvngkbvqvhpa")
    public suspend fun engineSecurityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineSecurityGroupId = mapped
    }

    /**
     * @param value The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.
     */
    @JvmName("qtdvilekccnlwhns")
    public suspend fun idpAuthUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idpAuthUrl = mapped
    }

    /**
     * @param value The name that your identity provider (IdP) uses for its RelayState parameter. For example, RelayState or TargetSource. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The RelayState parameter differs by IdP.
     */
    @JvmName("iqjtoftjkahgygqd")
    public suspend fun idpRelayStateParameterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idpRelayStateParameterName = mapped
    }

    /**
     * @param value A descriptive name for the Amazon EMR Studio.
     */
    @JvmName("oyctrrarxxyedcud")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to interoperate with other Amazon Web Services services.
     */
    @JvmName("fgnjqpeibidxvltg")
    public suspend fun serviceRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceRole = mapped
    }

    /**
     * @param value A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by `vpc_id`. Studio users can create a Workspace in any of the specified subnets.
     */
    @JvmName("ttegubunqigkfrre")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by `vpc_id`. Studio users can create a Workspace in any of the specified subnets.
     */
    @JvmName("yqbwolibsewgvynm")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lgaemefsinquvxcp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ukkqrueqlgjnnttk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a User Role when you use Amazon Web Services SSO authentication. The permissions attached to the User Role can be scoped down for each user or group using session policies.
     */
    @JvmName("wwlepuftqtnhvjxl")
    public suspend fun userRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userRole = mapped
    }

    /**
     * @param value The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.
     */
    @JvmName("obhktcsxxtlcdveq")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound network traffic to resources in the Engine security group, and it must be in the same VPC specified by `vpc_id`.
     * The following arguments are optional:
     */
    @JvmName("pnswrlxxbcdxwqce")
    public suspend fun workspaceSecurityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceSecurityGroupId = mapped
    }

    internal fun build(): StudioArgs = StudioArgs(
        authMode = authMode,
        defaultS3Location = defaultS3Location,
        description = description,
        engineSecurityGroupId = engineSecurityGroupId,
        idpAuthUrl = idpAuthUrl,
        idpRelayStateParameterName = idpRelayStateParameterName,
        name = name,
        serviceRole = serviceRole,
        subnetIds = subnetIds,
        tags = tags,
        userRole = userRole,
        vpcId = vpcId,
        workspaceSecurityGroupId = workspaceSecurityGroupId,
    )
}
