@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [StudioSessionMapping].
 */
@PulumiTagMarker
public class StudioSessionMappingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StudioSessionMappingArgs = StudioSessionMappingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StudioSessionMappingArgsBuilder.() -> Unit) {
        val builder = StudioSessionMappingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): StudioSessionMapping {
        val builtJavaResource = com.pulumi.aws.emr.StudioSessionMapping(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return StudioSessionMapping(builtJavaResource)
    }
}

/**
 * Provides an Elastic MapReduce Studio Session Mapping.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.StudioSessionMapping;
 * import com.pulumi.aws.emr.StudioSessionMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new StudioSessionMapping("example", StudioSessionMappingArgs.builder()
 *             .studioId(aws_emr_studio.example().id())
 *             .identityType("USER")
 *             .identityId("example")
 *             .sessionPolicyArn(aws_iam_policy.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EMR studio session mappings using `studio-id:identity-type:identity-id`. For example:
 * ```sh
 *  $ pulumi import aws:emr/studioSessionMapping:StudioSessionMapping example es-xxxxx:USER:xxxxx-xxx-xxx
 * ```
 *
 */
public class StudioSessionMapping internal constructor(
    override val javaResource: com.pulumi.aws.emr.StudioSessionMapping,
) : KotlinCustomResource(javaResource, StudioSessionMappingMapper) {
    /**
     * The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity Store.
     */
    public val identityId: Output<String>
        get() = javaResource.identityId().applyValue({ args0 -> args0 })

    /**
     * The name of the user or group from the Amazon Web Services SSO Identity Store.
     */
    public val identityName: Output<String>
        get() = javaResource.identityName().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the identity to map to the Amazon EMR Studio is a `USER` or a `GROUP`.
     */
    public val identityType: Output<String>
        get() = javaResource.identityType().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) for the session policy that will be applied to the user or group. You should specify the ARN for the session policy that you want to apply, not the ARN of your user role.
     */
    public val sessionPolicyArn: Output<String>
        get() = javaResource.sessionPolicyArn().applyValue({ args0 -> args0 })

    /**
     * The ID of the Amazon EMR Studio to which the user or group will be mapped.
     */
    public val studioId: Output<String>
        get() = javaResource.studioId().applyValue({ args0 -> args0 })
}

public object StudioSessionMappingMapper : ResourceMapper<StudioSessionMapping> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.emr.StudioSessionMapping::class == javaResource::class

    override fun map(javaResource: Resource): StudioSessionMapping = StudioSessionMapping(
        javaResource
            as com.pulumi.aws.emr.StudioSessionMapping,
    )
}

/**
 * @see [StudioSessionMapping].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StudioSessionMapping].
 */
public suspend fun studioSessionMapping(
    name: String,
    block: suspend StudioSessionMappingResourceBuilder.() -> Unit,
): StudioSessionMapping {
    val builder = StudioSessionMappingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StudioSessionMapping].
 * @param name The _unique_ name of the resulting resource.
 */
public fun studioSessionMapping(name: String): StudioSessionMapping {
    val builder = StudioSessionMappingResourceBuilder()
    builder.name(name)
    return builder.build()
}
