@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin

import com.pulumi.aws.emr.StudioSessionMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an Elastic MapReduce Studio Session Mapping.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.StudioSessionMapping;
 * import com.pulumi.aws.emr.StudioSessionMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new StudioSessionMapping("example", StudioSessionMappingArgs.builder()
 *             .studioId(aws_emr_studio.example().id())
 *             .identityType("USER")
 *             .identityId("example")
 *             .sessionPolicyArn(aws_iam_policy.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EMR studio session mappings using `studio-id:identity-type:identity-id`. For example:
 * ```sh
 *  $ pulumi import aws:emr/studioSessionMapping:StudioSessionMapping example es-xxxxx:USER:xxxxx-xxx-xxx
 * ```
 * @property identityId The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity Store.
 * @property identityName The name of the user or group from the Amazon Web Services SSO Identity Store.
 * @property identityType Specifies whether the identity to map to the Amazon EMR Studio is a `USER` or a `GROUP`.
 * @property sessionPolicyArn The Amazon Resource Name (ARN) for the session policy that will be applied to the user or group. You should specify the ARN for the session policy that you want to apply, not the ARN of your user role.
 * @property studioId The ID of the Amazon EMR Studio to which the user or group will be mapped.
 */
public data class StudioSessionMappingArgs(
    public val identityId: Output<String>? = null,
    public val identityName: Output<String>? = null,
    public val identityType: Output<String>? = null,
    public val sessionPolicyArn: Output<String>? = null,
    public val studioId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.StudioSessionMappingArgs> {
    override fun toJava(): com.pulumi.aws.emr.StudioSessionMappingArgs =
        com.pulumi.aws.emr.StudioSessionMappingArgs.builder()
            .identityId(identityId?.applyValue({ args0 -> args0 }))
            .identityName(identityName?.applyValue({ args0 -> args0 }))
            .identityType(identityType?.applyValue({ args0 -> args0 }))
            .sessionPolicyArn(sessionPolicyArn?.applyValue({ args0 -> args0 }))
            .studioId(studioId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StudioSessionMappingArgs].
 */
@PulumiTagMarker
public class StudioSessionMappingArgsBuilder internal constructor() {
    private var identityId: Output<String>? = null

    private var identityName: Output<String>? = null

    private var identityType: Output<String>? = null

    private var sessionPolicyArn: Output<String>? = null

    private var studioId: Output<String>? = null

    /**
     * @param value The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity Store.
     */
    @JvmName("jceiivjjghbtjnyp")
    public suspend fun identityId(`value`: Output<String>) {
        this.identityId = value
    }

    /**
     * @param value The name of the user or group from the Amazon Web Services SSO Identity Store.
     */
    @JvmName("ptjvdjwnrmsfkrlc")
    public suspend fun identityName(`value`: Output<String>) {
        this.identityName = value
    }

    /**
     * @param value Specifies whether the identity to map to the Amazon EMR Studio is a `USER` or a `GROUP`.
     */
    @JvmName("wqlwwbpennraxvlf")
    public suspend fun identityType(`value`: Output<String>) {
        this.identityType = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the session policy that will be applied to the user or group. You should specify the ARN for the session policy that you want to apply, not the ARN of your user role.
     */
    @JvmName("lnywogaljgkpmiyv")
    public suspend fun sessionPolicyArn(`value`: Output<String>) {
        this.sessionPolicyArn = value
    }

    /**
     * @param value The ID of the Amazon EMR Studio to which the user or group will be mapped.
     */
    @JvmName("rtntosvpmundfhdm")
    public suspend fun studioId(`value`: Output<String>) {
        this.studioId = value
    }

    /**
     * @param value The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity Store.
     */
    @JvmName("wnyypetahyvmutda")
    public suspend fun identityId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityId = mapped
    }

    /**
     * @param value The name of the user or group from the Amazon Web Services SSO Identity Store.
     */
    @JvmName("ykwpylgilrgmruud")
    public suspend fun identityName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityName = mapped
    }

    /**
     * @param value Specifies whether the identity to map to the Amazon EMR Studio is a `USER` or a `GROUP`.
     */
    @JvmName("vghvfxxfmksskepf")
    public suspend fun identityType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityType = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the session policy that will be applied to the user or group. You should specify the ARN for the session policy that you want to apply, not the ARN of your user role.
     */
    @JvmName("xeavrarehpcqymke")
    public suspend fun sessionPolicyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionPolicyArn = mapped
    }

    /**
     * @param value The ID of the Amazon EMR Studio to which the user or group will be mapped.
     */
    @JvmName("oyaiktvdltnihshf")
    public suspend fun studioId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.studioId = mapped
    }

    internal fun build(): StudioSessionMappingArgs = StudioSessionMappingArgs(
        identityId = identityId,
        identityName = identityName,
        identityType = identityType,
        sessionPolicyArn = sessionPolicyArn,
        studioId = studioId,
    )
}
