@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.ClusterAutoTerminationPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property idleTimeout Specifies the amount of idle time in seconds after which the cluster automatically terminates. You can specify a minimum of `60` seconds and a maximum of `604800` seconds (seven days).
 */
public data class ClusterAutoTerminationPolicyArgs(
    public val idleTimeout: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.inputs.ClusterAutoTerminationPolicyArgs> {
    override fun toJava(): com.pulumi.aws.emr.inputs.ClusterAutoTerminationPolicyArgs =
        com.pulumi.aws.emr.inputs.ClusterAutoTerminationPolicyArgs.builder()
            .idleTimeout(idleTimeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterAutoTerminationPolicyArgs].
 */
@PulumiTagMarker
public class ClusterAutoTerminationPolicyArgsBuilder internal constructor() {
    private var idleTimeout: Output<Int>? = null

    /**
     * @param value Specifies the amount of idle time in seconds after which the cluster automatically terminates. You can specify a minimum of `60` seconds and a maximum of `604800` seconds (seven days).
     */
    @JvmName("tvujwjhcupwgjwwm")
    public suspend fun idleTimeout(`value`: Output<Int>) {
        this.idleTimeout = value
    }

    /**
     * @param value Specifies the amount of idle time in seconds after which the cluster automatically terminates. You can specify a minimum of `60` seconds and a maximum of `604800` seconds (seven days).
     */
    @JvmName("rewsdujomexhtirf")
    public suspend fun idleTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleTimeout = mapped
    }

    internal fun build(): ClusterAutoTerminationPolicyArgs = ClusterAutoTerminationPolicyArgs(
        idleTimeout = idleTimeout,
    )
}
