@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.ClusterBootstrapActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property args List of command line arguments to pass to the bootstrap action script.
 * @property name Name of the bootstrap action.
 * @property path Location of the script to run during a bootstrap action. Can be either a location in Amazon S3 or on a local file system.
 */
public data class ClusterBootstrapActionArgs(
    public val args: Output<List<String>>? = null,
    public val name: Output<String>,
    public val path: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.emr.inputs.ClusterBootstrapActionArgs> {
    override fun toJava(): com.pulumi.aws.emr.inputs.ClusterBootstrapActionArgs =
        com.pulumi.aws.emr.inputs.ClusterBootstrapActionArgs.builder()
            .args(args?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .path(path.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterBootstrapActionArgs].
 */
@PulumiTagMarker
public class ClusterBootstrapActionArgsBuilder internal constructor() {
    private var args: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var path: Output<String>? = null

    /**
     * @param value List of command line arguments to pass to the bootstrap action script.
     */
    @JvmName("psqmdcpetqsrucyu")
    public suspend fun args(`value`: Output<List<String>>) {
        this.args = value
    }

    @JvmName("vbvsinphwvoaosft")
    public suspend fun args(vararg values: Output<String>) {
        this.args = Output.all(values.asList())
    }

    /**
     * @param values List of command line arguments to pass to the bootstrap action script.
     */
    @JvmName("okufrfiokhpsvqfi")
    public suspend fun args(values: List<Output<String>>) {
        this.args = Output.all(values)
    }

    /**
     * @param value Name of the bootstrap action.
     */
    @JvmName("gmmbolucvddltsmc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Location of the script to run during a bootstrap action. Can be either a location in Amazon S3 or on a local file system.
     */
    @JvmName("ohdrghcfueeqkcwv")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value List of command line arguments to pass to the bootstrap action script.
     */
    @JvmName("jbpjyyeekrbkfcao")
    public suspend fun args(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param values List of command line arguments to pass to the bootstrap action script.
     */
    @JvmName("jtfqfrdwstqfopnu")
    public suspend fun args(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param value Name of the bootstrap action.
     */
    @JvmName("wcnmvrsxcuepwtlo")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Location of the script to run during a bootstrap action. Can be either a location in Amazon S3 or on a local file system.
     */
    @JvmName("doiilgmpcojydltq")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): ClusterBootstrapActionArgs = ClusterBootstrapActionArgs(
        args = args,
        name = name ?: throw PulumiNullFieldException("name"),
        path = path ?: throw PulumiNullFieldException("path"),
    )
}
