@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property classification Classification within a configuration.
 * @property properties Map of properties specified within a configuration classification.
 */
public data class ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgs(
    public val classification: Output<String>? = null,
    public val properties: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgs =
        com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgs.builder()
            .classification(classification?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgs].
 */
@PulumiTagMarker
public class ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgsBuilder internal
constructor() {
    private var classification: Output<String>? = null

    private var properties: Output<Map<String, String>>? = null

    /**
     * @param value Classification within a configuration.
     */
    @JvmName("utgversxthaohfod")
    public suspend fun classification(`value`: Output<String>) {
        this.classification = value
    }

    /**
     * @param value Map of properties specified within a configuration classification.
     */
    @JvmName("isgnxssxdjgjkqae")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Classification within a configuration.
     */
    @JvmName("kjrhubnuvfmwwjnc")
    public suspend fun classification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.classification = mapped
    }

    /**
     * @param value Map of properties specified within a configuration classification.
     */
    @JvmName("ecrtuacdroxsryxh")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values Map of properties specified within a configuration classification.
     */
    @JvmName("iovwnrpjiukjlhdi")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    internal fun build(): ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgs =
        ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgs(
            classification = classification,
            properties = properties,
        )
}
