@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetLaunchSpecificationsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property onDemandSpecifications Configuration block for on demand instances launch specifications.
 * @property spotSpecifications Configuration block for spot instances launch specifications.
 */
public data class ClusterCoreInstanceFleetLaunchSpecificationsArgs(
    public val onDemandSpecifications:
    Output<List<ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs>>? = null,
    public val spotSpecifications:
    Output<List<ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecificationArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetLaunchSpecificationsArgs> {
    override fun toJava(): com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetLaunchSpecificationsArgs =
        com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetLaunchSpecificationsArgs.builder()
            .onDemandSpecifications(
                onDemandSpecifications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .spotSpecifications(
                spotSpecifications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ClusterCoreInstanceFleetLaunchSpecificationsArgs].
 */
@PulumiTagMarker
public class ClusterCoreInstanceFleetLaunchSpecificationsArgsBuilder internal constructor() {
    private var onDemandSpecifications:
        Output<List<ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs>>? = null

    private var spotSpecifications:
        Output<List<ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecificationArgs>>? = null

    /**
     * @param value Configuration block for on demand instances launch specifications.
     */
    @JvmName("yrkwicneyqbldlsb")
    public suspend
    fun onDemandSpecifications(`value`: Output<List<ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs>>) {
        this.onDemandSpecifications = value
    }

    @JvmName("qnsbdumqjylkirqf")
    public suspend fun onDemandSpecifications(
        vararg
        values: Output<ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs>,
    ) {
        this.onDemandSpecifications = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for on demand instances launch specifications.
     */
    @JvmName("xyrrjfybnypbdekn")
    public suspend
    fun onDemandSpecifications(values: List<Output<ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs>>) {
        this.onDemandSpecifications = Output.all(values)
    }

    /**
     * @param value Configuration block for spot instances launch specifications.
     */
    @JvmName("qwkeqvahjegqbffi")
    public suspend
    fun spotSpecifications(`value`: Output<List<ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecificationArgs>>) {
        this.spotSpecifications = value
    }

    @JvmName("aoiojydqbrbfxpyb")
    public suspend fun spotSpecifications(
        vararg
        values: Output<ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecificationArgs>,
    ) {
        this.spotSpecifications = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for spot instances launch specifications.
     */
    @JvmName("lohaohlsclnxhqom")
    public suspend
    fun spotSpecifications(values: List<Output<ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecificationArgs>>) {
        this.spotSpecifications = Output.all(values)
    }

    /**
     * @param value Configuration block for on demand instances launch specifications.
     */
    @JvmName("oddygejqvrpbqmno")
    public suspend
    fun onDemandSpecifications(`value`: List<ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onDemandSpecifications = mapped
    }

    /**
     * @param argument Configuration block for on demand instances launch specifications.
     */
    @JvmName("hoindbdvgegrwfxk")
    public suspend
    fun onDemandSpecifications(argument: List<suspend ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.onDemandSpecifications = mapped
    }

    /**
     * @param argument Configuration block for on demand instances launch specifications.
     */
    @JvmName("nefvesprkqxbtwom")
    public suspend fun onDemandSpecifications(
        vararg
        argument: suspend ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.onDemandSpecifications = mapped
    }

    /**
     * @param argument Configuration block for on demand instances launch specifications.
     */
    @JvmName("rjtrufbqecgkdvoc")
    public suspend
    fun onDemandSpecifications(argument: suspend ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.onDemandSpecifications = mapped
    }

    /**
     * @param values Configuration block for on demand instances launch specifications.
     */
    @JvmName("frlgvhxseecjskma")
    public suspend fun onDemandSpecifications(
        vararg
        values: ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onDemandSpecifications = mapped
    }

    /**
     * @param value Configuration block for spot instances launch specifications.
     */
    @JvmName("grtcfsnbrjglffkh")
    public suspend
    fun spotSpecifications(`value`: List<ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotSpecifications = mapped
    }

    /**
     * @param argument Configuration block for spot instances launch specifications.
     */
    @JvmName("cluhhvnlfvkllxxa")
    public suspend
    fun spotSpecifications(argument: List<suspend ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.spotSpecifications = mapped
    }

    /**
     * @param argument Configuration block for spot instances launch specifications.
     */
    @JvmName("mepanesfvxbmwfei")
    public suspend fun spotSpecifications(
        vararg
        argument: suspend ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecificationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.spotSpecifications = mapped
    }

    /**
     * @param argument Configuration block for spot instances launch specifications.
     */
    @JvmName("vhstqyuuwsgldqhy")
    public suspend
    fun spotSpecifications(argument: suspend ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecificationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.spotSpecifications = mapped
    }

    /**
     * @param values Configuration block for spot instances launch specifications.
     */
    @JvmName("ukwyjbxoqvtvpdnp")
    public suspend fun spotSpecifications(
        vararg
        values: ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecificationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.spotSpecifications = mapped
    }

    internal fun build(): ClusterCoreInstanceFleetLaunchSpecificationsArgs =
        ClusterCoreInstanceFleetLaunchSpecificationsArgs(
            onDemandSpecifications = onDemandSpecifications,
            spotSpecifications = spotSpecifications,
        )
}
