@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property classification Classification within a configuration.
 * @property properties Map of properties specified within a configuration classification.
 */
public data class ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgs(
    public val classification: Output<String>? = null,
    public val properties: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.emr.inputs.ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.emr.inputs.ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgs =
        com.pulumi.aws.emr.inputs.ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgs.builder()
            .classification(classification?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgs].
 */
@PulumiTagMarker
public class ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgsBuilder internal
constructor() {
    private var classification: Output<String>? = null

    private var properties: Output<Map<String, String>>? = null

    /**
     * @param value Classification within a configuration.
     */
    @JvmName("sckwkkksenkfvrsu")
    public suspend fun classification(`value`: Output<String>) {
        this.classification = value
    }

    /**
     * @param value Map of properties specified within a configuration classification.
     */
    @JvmName("wfjtwcamiwleibgw")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Classification within a configuration.
     */
    @JvmName("egerqdwpjgmnrurm")
    public suspend fun classification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.classification = mapped
    }

    /**
     * @param value Map of properties specified within a configuration classification.
     */
    @JvmName("dwriqojnmxdsxdos")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values Map of properties specified within a configuration classification.
     */
    @JvmName("pqhbfdlgafhtkvah")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    internal fun build(): ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgs =
        ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgs(
            classification = classification,
            properties = properties,
        )
}
