@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.ClusterMasterInstanceFleetLaunchSpecificationsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property onDemandSpecifications Configuration block for on demand instances launch specifications.
 * @property spotSpecifications Configuration block for spot instances launch specifications.
 */
public data class ClusterMasterInstanceFleetLaunchSpecificationsArgs(
    public val onDemandSpecifications:
    Output<List<ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs>>? = null,
    public val spotSpecifications:
    Output<List<ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecificationArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.inputs.ClusterMasterInstanceFleetLaunchSpecificationsArgs> {
    override fun toJava():
        com.pulumi.aws.emr.inputs.ClusterMasterInstanceFleetLaunchSpecificationsArgs =
        com.pulumi.aws.emr.inputs.ClusterMasterInstanceFleetLaunchSpecificationsArgs.builder()
            .onDemandSpecifications(
                onDemandSpecifications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .spotSpecifications(
                spotSpecifications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ClusterMasterInstanceFleetLaunchSpecificationsArgs].
 */
@PulumiTagMarker
public class ClusterMasterInstanceFleetLaunchSpecificationsArgsBuilder internal constructor() {
    private var onDemandSpecifications:
        Output<List<ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs>>? = null

    private var spotSpecifications:
        Output<List<ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecificationArgs>>? = null

    /**
     * @param value Configuration block for on demand instances launch specifications.
     */
    @JvmName("pyapilsyswffdmpx")
    public suspend
    fun onDemandSpecifications(`value`: Output<List<ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs>>) {
        this.onDemandSpecifications = value
    }

    @JvmName("exlmrbwsgdtckqle")
    public suspend fun onDemandSpecifications(
        vararg
        values: Output<ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs>,
    ) {
        this.onDemandSpecifications = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for on demand instances launch specifications.
     */
    @JvmName("vxsoprkeacgwvfdo")
    public suspend
    fun onDemandSpecifications(values: List<Output<ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs>>) {
        this.onDemandSpecifications = Output.all(values)
    }

    /**
     * @param value Configuration block for spot instances launch specifications.
     */
    @JvmName("jjnmvxierbjyeqmh")
    public suspend
    fun spotSpecifications(`value`: Output<List<ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecificationArgs>>) {
        this.spotSpecifications = value
    }

    @JvmName("exwdbjhypknjffdk")
    public suspend fun spotSpecifications(
        vararg
        values: Output<ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecificationArgs>,
    ) {
        this.spotSpecifications = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for spot instances launch specifications.
     */
    @JvmName("wkcmwrpnaaoxybcb")
    public suspend
    fun spotSpecifications(values: List<Output<ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecificationArgs>>) {
        this.spotSpecifications = Output.all(values)
    }

    /**
     * @param value Configuration block for on demand instances launch specifications.
     */
    @JvmName("fesycmxfbysdwlrx")
    public suspend
    fun onDemandSpecifications(`value`: List<ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onDemandSpecifications = mapped
    }

    /**
     * @param argument Configuration block for on demand instances launch specifications.
     */
    @JvmName("vqgjqmkrhsbnmkmb")
    public suspend
    fun onDemandSpecifications(argument: List<suspend ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.onDemandSpecifications = mapped
    }

    /**
     * @param argument Configuration block for on demand instances launch specifications.
     */
    @JvmName("iflvssusccfgxcrs")
    public suspend fun onDemandSpecifications(
        vararg
        argument: suspend ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecificationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.onDemandSpecifications = mapped
    }

    /**
     * @param argument Configuration block for on demand instances launch specifications.
     */
    @JvmName("vxhorlntwcpltqgf")
    public suspend
    fun onDemandSpecifications(argument: suspend ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecificationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.onDemandSpecifications = mapped
    }

    /**
     * @param values Configuration block for on demand instances launch specifications.
     */
    @JvmName("rqsmufamnoykgucu")
    public suspend fun onDemandSpecifications(
        vararg
        values: ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onDemandSpecifications = mapped
    }

    /**
     * @param value Configuration block for spot instances launch specifications.
     */
    @JvmName("gohehdgrljyslmid")
    public suspend
    fun spotSpecifications(`value`: List<ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotSpecifications = mapped
    }

    /**
     * @param argument Configuration block for spot instances launch specifications.
     */
    @JvmName("bmnjkttoqmurwgea")
    public suspend
    fun spotSpecifications(argument: List<suspend ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.spotSpecifications = mapped
    }

    /**
     * @param argument Configuration block for spot instances launch specifications.
     */
    @JvmName("rjmsdtwawsimqrud")
    public suspend fun spotSpecifications(
        vararg
        argument: suspend ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecificationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.spotSpecifications = mapped
    }

    /**
     * @param argument Configuration block for spot instances launch specifications.
     */
    @JvmName("xpvjxyrfulceyjrq")
    public suspend
    fun spotSpecifications(argument: suspend ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecificationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.spotSpecifications = mapped
    }

    /**
     * @param values Configuration block for spot instances launch specifications.
     */
    @JvmName("elngljtuwwdqjgpf")
    public suspend fun spotSpecifications(
        vararg
        values: ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecificationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.spotSpecifications = mapped
    }

    internal fun build(): ClusterMasterInstanceFleetLaunchSpecificationsArgs =
        ClusterMasterInstanceFleetLaunchSpecificationsArgs(
            onDemandSpecifications = onDemandSpecifications,
            spotSpecifications = spotSpecifications,
        )
}
