@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.ClusterStepHadoopJarStepArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property args List of command line arguments passed to the JAR file's main function when executed.
 * @property jar Path to a JAR file run during the step.
 * @property mainClass Name of the main class in the specified Java file. If not specified, the JAR file should specify a Main-Class in its manifest file.
 * @property properties Key-Value map of Java properties that are set when the step runs. You can use these properties to pass key value pairs to your main function.
 */
public data class ClusterStepHadoopJarStepArgs(
    public val args: Output<List<String>>? = null,
    public val jar: Output<String>,
    public val mainClass: Output<String>? = null,
    public val properties: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.inputs.ClusterStepHadoopJarStepArgs> {
    override fun toJava(): com.pulumi.aws.emr.inputs.ClusterStepHadoopJarStepArgs =
        com.pulumi.aws.emr.inputs.ClusterStepHadoopJarStepArgs.builder()
            .args(args?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .jar(jar.applyValue({ args0 -> args0 }))
            .mainClass(mainClass?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ClusterStepHadoopJarStepArgs].
 */
@PulumiTagMarker
public class ClusterStepHadoopJarStepArgsBuilder internal constructor() {
    private var args: Output<List<String>>? = null

    private var jar: Output<String>? = null

    private var mainClass: Output<String>? = null

    private var properties: Output<Map<String, String>>? = null

    /**
     * @param value List of command line arguments passed to the JAR file's main function when executed.
     */
    @JvmName("veayffpoumlxtaug")
    public suspend fun args(`value`: Output<List<String>>) {
        this.args = value
    }

    @JvmName("nvdsuokcciojhqmw")
    public suspend fun args(vararg values: Output<String>) {
        this.args = Output.all(values.asList())
    }

    /**
     * @param values List of command line arguments passed to the JAR file's main function when executed.
     */
    @JvmName("cdatjbqkirpuxtvq")
    public suspend fun args(values: List<Output<String>>) {
        this.args = Output.all(values)
    }

    /**
     * @param value Path to a JAR file run during the step.
     */
    @JvmName("ufawpdgfsgojkxqv")
    public suspend fun jar(`value`: Output<String>) {
        this.jar = value
    }

    /**
     * @param value Name of the main class in the specified Java file. If not specified, the JAR file should specify a Main-Class in its manifest file.
     */
    @JvmName("thyjhfljrgmlvnwl")
    public suspend fun mainClass(`value`: Output<String>) {
        this.mainClass = value
    }

    /**
     * @param value Key-Value map of Java properties that are set when the step runs. You can use these properties to pass key value pairs to your main function.
     */
    @JvmName("bmhpprnbldnjrmcw")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value List of command line arguments passed to the JAR file's main function when executed.
     */
    @JvmName("rkdgguslyaelbxyp")
    public suspend fun args(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param values List of command line arguments passed to the JAR file's main function when executed.
     */
    @JvmName("wrkrsbucgutmpgyy")
    public suspend fun args(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param value Path to a JAR file run during the step.
     */
    @JvmName("djhglrduxbigtapx")
    public suspend fun jar(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jar = mapped
    }

    /**
     * @param value Name of the main class in the specified Java file. If not specified, the JAR file should specify a Main-Class in its manifest file.
     */
    @JvmName("tobtabnparhkmdbo")
    public suspend fun mainClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mainClass = mapped
    }

    /**
     * @param value Key-Value map of Java properties that are set when the step runs. You can use these properties to pass key value pairs to your main function.
     */
    @JvmName("hwufjpsulrnqvulc")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values Key-Value map of Java properties that are set when the step runs. You can use these properties to pass key value pairs to your main function.
     */
    @JvmName("ijkfysrtflobikld")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    internal fun build(): ClusterStepHadoopJarStepArgs = ClusterStepHadoopJarStepArgs(
        args = args,
        jar = jar ?: throw PulumiNullFieldException("jar"),
        mainClass = mainClass,
        properties = properties,
    )
}
