@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.GetReleaseLabelsFilters.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property application Optional release label application filter. For example, `Spark@2.1.0` or `Spark`.
 * @property prefix Optional release label version prefix filter. For example, `emr-5`.
 */
public data class GetReleaseLabelsFilters(
    public val application: String? = null,
    public val prefix: String? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.inputs.GetReleaseLabelsFilters> {
    override fun toJava(): com.pulumi.aws.emr.inputs.GetReleaseLabelsFilters =
        com.pulumi.aws.emr.inputs.GetReleaseLabelsFilters.builder()
            .application(application?.let({ args0 -> args0 }))
            .prefix(prefix?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReleaseLabelsFilters].
 */
@PulumiTagMarker
public class GetReleaseLabelsFiltersBuilder internal constructor() {
    private var application: String? = null

    private var prefix: String? = null

    /**
     * @param value Optional release label application filter. For example, `Spark@2.1.0` or `Spark`.
     */
    @JvmName("wsxwtrwqplisfvcl")
    public suspend fun application(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.application = mapped
    }

    /**
     * @param value Optional release label version prefix filter. For example, `emr-5`.
     */
    @JvmName("rwghttinnrdnkocl")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.prefix = mapped
    }

    internal fun build(): GetReleaseLabelsFilters = GetReleaseLabelsFilters(
        application = application,
        prefix = prefix,
    )
}
