@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.GetSupportedInstanceTypesSupportedInstanceType.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property architecture CPU architecture.
 * @property ebsOptimizedAvailable Indicates whether the instance type supports Amazon EBS optimization.
 * @property ebsOptimizedByDefault Indicates whether the instance type uses Amazon EBS optimization by default.
 * @property ebsStorageOnly Indicates whether the instance type only supports Amazon EBS.
 * @property instanceFamilyId The Amazon EC2 family and generation for the instance type.
 * @property is64BitsOnly Indicates whether the instance type only supports 64-bit architecture.
 * @property memoryGb Memory that is available to Amazon EMR from the instance type.
 * @property numberOfDisks Number of disks for the instance type.
 * @property storageGb Storage capacity of the instance type.
 * @property type Amazon EC2 instance type. For example, `m5.xlarge`.
 * @property vcpu The number of vCPUs available for the instance type.
 */
public data class GetSupportedInstanceTypesSupportedInstanceType(
    public val architecture: String,
    public val ebsOptimizedAvailable: Boolean,
    public val ebsOptimizedByDefault: Boolean,
    public val ebsStorageOnly: Boolean,
    public val instanceFamilyId: String,
    public val is64BitsOnly: Boolean,
    public val memoryGb: Double,
    public val numberOfDisks: Int,
    public val storageGb: Int,
    public val type: String,
    public val vcpu: Int,
) : ConvertibleToJava<com.pulumi.aws.emr.inputs.GetSupportedInstanceTypesSupportedInstanceType> {
    override fun toJava(): com.pulumi.aws.emr.inputs.GetSupportedInstanceTypesSupportedInstanceType =
        com.pulumi.aws.emr.inputs.GetSupportedInstanceTypesSupportedInstanceType.builder()
            .architecture(architecture.let({ args0 -> args0 }))
            .ebsOptimizedAvailable(ebsOptimizedAvailable.let({ args0 -> args0 }))
            .ebsOptimizedByDefault(ebsOptimizedByDefault.let({ args0 -> args0 }))
            .ebsStorageOnly(ebsStorageOnly.let({ args0 -> args0 }))
            .instanceFamilyId(instanceFamilyId.let({ args0 -> args0 }))
            .is64BitsOnly(is64BitsOnly.let({ args0 -> args0 }))
            .memoryGb(memoryGb.let({ args0 -> args0 }))
            .numberOfDisks(numberOfDisks.let({ args0 -> args0 }))
            .storageGb(storageGb.let({ args0 -> args0 }))
            .type(type.let({ args0 -> args0 }))
            .vcpu(vcpu.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSupportedInstanceTypesSupportedInstanceType].
 */
@PulumiTagMarker
public class GetSupportedInstanceTypesSupportedInstanceTypeBuilder internal constructor() {
    private var architecture: String? = null

    private var ebsOptimizedAvailable: Boolean? = null

    private var ebsOptimizedByDefault: Boolean? = null

    private var ebsStorageOnly: Boolean? = null

    private var instanceFamilyId: String? = null

    private var is64BitsOnly: Boolean? = null

    private var memoryGb: Double? = null

    private var numberOfDisks: Int? = null

    private var storageGb: Int? = null

    private var type: String? = null

    private var vcpu: Int? = null

    /**
     * @param value CPU architecture.
     */
    @JvmName("ghvyftianatxeplj")
    public suspend fun architecture(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.architecture = mapped
    }

    /**
     * @param value Indicates whether the instance type supports Amazon EBS optimization.
     */
    @JvmName("tlujvuphcwkeambu")
    public suspend fun ebsOptimizedAvailable(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ebsOptimizedAvailable = mapped
    }

    /**
     * @param value Indicates whether the instance type uses Amazon EBS optimization by default.
     */
    @JvmName("sbnfjawhlpuiqatd")
    public suspend fun ebsOptimizedByDefault(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ebsOptimizedByDefault = mapped
    }

    /**
     * @param value Indicates whether the instance type only supports Amazon EBS.
     */
    @JvmName("fdfbffblvtgvldmu")
    public suspend fun ebsStorageOnly(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ebsStorageOnly = mapped
    }

    /**
     * @param value The Amazon EC2 family and generation for the instance type.
     */
    @JvmName("qjdpjbijsiyxdjxl")
    public suspend fun instanceFamilyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceFamilyId = mapped
    }

    /**
     * @param value Indicates whether the instance type only supports 64-bit architecture.
     */
    @JvmName("vmdfglsstacnmpwd")
    public suspend fun is64BitsOnly(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.is64BitsOnly = mapped
    }

    /**
     * @param value Memory that is available to Amazon EMR from the instance type.
     */
    @JvmName("prbjpffdxwixqctd")
    public suspend fun memoryGb(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.memoryGb = mapped
    }

    /**
     * @param value Number of disks for the instance type.
     */
    @JvmName("hujyaxfwmoqhfnen")
    public suspend fun numberOfDisks(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.numberOfDisks = mapped
    }

    /**
     * @param value Storage capacity of the instance type.
     */
    @JvmName("nybundikwwtxblqt")
    public suspend fun storageGb(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageGb = mapped
    }

    /**
     * @param value Amazon EC2 instance type. For example, `m5.xlarge`.
     */
    @JvmName("rxtrhadcfvocluqp")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    /**
     * @param value The number of vCPUs available for the instance type.
     */
    @JvmName("qivseiojfrmfrrbc")
    public suspend fun vcpu(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vcpu = mapped
    }

    internal fun build(): GetSupportedInstanceTypesSupportedInstanceType =
        GetSupportedInstanceTypesSupportedInstanceType(
            architecture = architecture ?: throw PulumiNullFieldException("architecture"),
            ebsOptimizedAvailable = ebsOptimizedAvailable ?: throw
                PulumiNullFieldException("ebsOptimizedAvailable"),
            ebsOptimizedByDefault = ebsOptimizedByDefault ?: throw
                PulumiNullFieldException("ebsOptimizedByDefault"),
            ebsStorageOnly = ebsStorageOnly ?: throw PulumiNullFieldException("ebsStorageOnly"),
            instanceFamilyId = instanceFamilyId ?: throw PulumiNullFieldException("instanceFamilyId"),
            is64BitsOnly = is64BitsOnly ?: throw PulumiNullFieldException("is64BitsOnly"),
            memoryGb = memoryGb ?: throw PulumiNullFieldException("memoryGb"),
            numberOfDisks = numberOfDisks ?: throw PulumiNullFieldException("numberOfDisks"),
            storageGb = storageGb ?: throw PulumiNullFieldException("storageGb"),
            type = type ?: throw PulumiNullFieldException("type"),
            vcpu = vcpu ?: throw PulumiNullFieldException("vcpu"),
        )
}
