@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.InstanceFleetLaunchSpecificationsOnDemandSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property allocationStrategy Specifies the strategy to use in launching Spot instance fleets. Currently, the only option is `capacity-optimized` (the default), which launches instances from Spot instance pools with optimal capacity for the number of instances that are launching.
 */
public data class InstanceFleetLaunchSpecificationsOnDemandSpecificationArgs(
    public val allocationStrategy: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.emr.inputs.InstanceFleetLaunchSpecificationsOnDemandSpecificationArgs> {
    override fun toJava():
        com.pulumi.aws.emr.inputs.InstanceFleetLaunchSpecificationsOnDemandSpecificationArgs =
        com.pulumi.aws.emr.inputs.InstanceFleetLaunchSpecificationsOnDemandSpecificationArgs.builder()
            .allocationStrategy(allocationStrategy.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceFleetLaunchSpecificationsOnDemandSpecificationArgs].
 */
@PulumiTagMarker
public class InstanceFleetLaunchSpecificationsOnDemandSpecificationArgsBuilder internal
constructor() {
    private var allocationStrategy: Output<String>? = null

    /**
     * @param value Specifies the strategy to use in launching Spot instance fleets. Currently, the only option is `capacity-optimized` (the default), which launches instances from Spot instance pools with optimal capacity for the number of instances that are launching.
     */
    @JvmName("lxecgryiqxhtapng")
    public suspend fun allocationStrategy(`value`: Output<String>) {
        this.allocationStrategy = value
    }

    /**
     * @param value Specifies the strategy to use in launching Spot instance fleets. Currently, the only option is `capacity-optimized` (the default), which launches instances from Spot instance pools with optimal capacity for the number of instances that are launching.
     */
    @JvmName("sisuxnmctbnplpox")
    public suspend fun allocationStrategy(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allocationStrategy = mapped
    }

    internal fun build(): InstanceFleetLaunchSpecificationsOnDemandSpecificationArgs =
        InstanceFleetLaunchSpecificationsOnDemandSpecificationArgs(
            allocationStrategy = allocationStrategy ?: throw PulumiNullFieldException("allocationStrategy"),
        )
}
