@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.InstanceFleetLaunchSpecificationsSpotSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property allocationStrategy Specifies the strategy to use in launching Spot instance fleets. Currently, the only option is `capacity-optimized` (the default), which launches instances from Spot instance pools with optimal capacity for the number of instances that are launching.
 * @property blockDurationMinutes The defined duration for Spot instances (also known as Spot blocks) in minutes. When specified, the Spot instance does not terminate before the defined duration expires, and defined duration pricing for Spot instances applies. Valid values are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as a Spot instance receives its instance ID. At the end of the duration, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
 * @property timeoutAction The action to take when TargetSpotCapacity has not been fulfilled when the TimeoutDurationMinutes has expired; that is, when all Spot instances could not be provisioned within the Spot provisioning timeout. Valid values are `TERMINATE_CLUSTER` and `SWITCH_TO_ON_DEMAND`. SWITCH_TO_ON_DEMAND specifies that if no Spot instances are available, On-Demand Instances should be provisioned to fulfill any remaining Spot capacity.
 * @property timeoutDurationMinutes The spot provisioning timeout period in minutes. If Spot instances are not provisioned within this time period, the TimeOutAction is taken. Minimum value is 5 and maximum value is 1440. The timeout applies only during initial provisioning, when the cluster is first created.
 */
public data class InstanceFleetLaunchSpecificationsSpotSpecificationArgs(
    public val allocationStrategy: Output<String>,
    public val blockDurationMinutes: Output<Int>? = null,
    public val timeoutAction: Output<String>,
    public val timeoutDurationMinutes: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.emr.inputs.InstanceFleetLaunchSpecificationsSpotSpecificationArgs> {
    override fun toJava():
        com.pulumi.aws.emr.inputs.InstanceFleetLaunchSpecificationsSpotSpecificationArgs =
        com.pulumi.aws.emr.inputs.InstanceFleetLaunchSpecificationsSpotSpecificationArgs.builder()
            .allocationStrategy(allocationStrategy.applyValue({ args0 -> args0 }))
            .blockDurationMinutes(blockDurationMinutes?.applyValue({ args0 -> args0 }))
            .timeoutAction(timeoutAction.applyValue({ args0 -> args0 }))
            .timeoutDurationMinutes(timeoutDurationMinutes.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceFleetLaunchSpecificationsSpotSpecificationArgs].
 */
@PulumiTagMarker
public class InstanceFleetLaunchSpecificationsSpotSpecificationArgsBuilder internal constructor() {
    private var allocationStrategy: Output<String>? = null

    private var blockDurationMinutes: Output<Int>? = null

    private var timeoutAction: Output<String>? = null

    private var timeoutDurationMinutes: Output<Int>? = null

    /**
     * @param value Specifies the strategy to use in launching Spot instance fleets. Currently, the only option is `capacity-optimized` (the default), which launches instances from Spot instance pools with optimal capacity for the number of instances that are launching.
     */
    @JvmName("evclgnflaaoqngdn")
    public suspend fun allocationStrategy(`value`: Output<String>) {
        this.allocationStrategy = value
    }

    /**
     * @param value The defined duration for Spot instances (also known as Spot blocks) in minutes. When specified, the Spot instance does not terminate before the defined duration expires, and defined duration pricing for Spot instances applies. Valid values are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as a Spot instance receives its instance ID. At the end of the duration, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
     */
    @JvmName("ippnxgkvfstrrmjb")
    public suspend fun blockDurationMinutes(`value`: Output<Int>) {
        this.blockDurationMinutes = value
    }

    /**
     * @param value The action to take when TargetSpotCapacity has not been fulfilled when the TimeoutDurationMinutes has expired; that is, when all Spot instances could not be provisioned within the Spot provisioning timeout. Valid values are `TERMINATE_CLUSTER` and `SWITCH_TO_ON_DEMAND`. SWITCH_TO_ON_DEMAND specifies that if no Spot instances are available, On-Demand Instances should be provisioned to fulfill any remaining Spot capacity.
     */
    @JvmName("ordnrqvitqvwyqeg")
    public suspend fun timeoutAction(`value`: Output<String>) {
        this.timeoutAction = value
    }

    /**
     * @param value The spot provisioning timeout period in minutes. If Spot instances are not provisioned within this time period, the TimeOutAction is taken. Minimum value is 5 and maximum value is 1440. The timeout applies only during initial provisioning, when the cluster is first created.
     */
    @JvmName("aydwfsryiibtknxp")
    public suspend fun timeoutDurationMinutes(`value`: Output<Int>) {
        this.timeoutDurationMinutes = value
    }

    /**
     * @param value Specifies the strategy to use in launching Spot instance fleets. Currently, the only option is `capacity-optimized` (the default), which launches instances from Spot instance pools with optimal capacity for the number of instances that are launching.
     */
    @JvmName("qgnygfbqexolibtf")
    public suspend fun allocationStrategy(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allocationStrategy = mapped
    }

    /**
     * @param value The defined duration for Spot instances (also known as Spot blocks) in minutes. When specified, the Spot instance does not terminate before the defined duration expires, and defined duration pricing for Spot instances applies. Valid values are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as a Spot instance receives its instance ID. At the end of the duration, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
     */
    @JvmName("ktwfcrwouojvwitm")
    public suspend fun blockDurationMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockDurationMinutes = mapped
    }

    /**
     * @param value The action to take when TargetSpotCapacity has not been fulfilled when the TimeoutDurationMinutes has expired; that is, when all Spot instances could not be provisioned within the Spot provisioning timeout. Valid values are `TERMINATE_CLUSTER` and `SWITCH_TO_ON_DEMAND`. SWITCH_TO_ON_DEMAND specifies that if no Spot instances are available, On-Demand Instances should be provisioned to fulfill any remaining Spot capacity.
     */
    @JvmName("dglnxsapeqkhabrj")
    public suspend fun timeoutAction(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeoutAction = mapped
    }

    /**
     * @param value The spot provisioning timeout period in minutes. If Spot instances are not provisioned within this time period, the TimeOutAction is taken. Minimum value is 5 and maximum value is 1440. The timeout applies only during initial provisioning, when the cluster is first created.
     */
    @JvmName("wsorkoidisaaoytd")
    public suspend fun timeoutDurationMinutes(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeoutDurationMinutes = mapped
    }

    internal fun build(): InstanceFleetLaunchSpecificationsSpotSpecificationArgs =
        InstanceFleetLaunchSpecificationsSpotSpecificationArgs(
            allocationStrategy = allocationStrategy ?: throw PulumiNullFieldException("allocationStrategy"),
            blockDurationMinutes = blockDurationMinutes,
            timeoutAction = timeoutAction ?: throw PulumiNullFieldException("timeoutAction"),
            timeoutDurationMinutes = timeoutDurationMinutes ?: throw
                PulumiNullFieldException("timeoutDurationMinutes"),
        )
}
