@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.InstanceGroupEbsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property iops The number of I/O operations per second (IOPS) that the volume supports.
 * @property size The volume size, in gibibytes (GiB). This can be a number from 1 - 1024. If the volume type is EBS-optimized, the minimum value is 10.
 * @property type The volume type. Valid options are 'gp2', 'io1' and 'standard'.
 * @property volumesPerInstance The number of EBS Volumes to attach per instance.
 */
public data class InstanceGroupEbsConfigArgs(
    public val iops: Output<Int>? = null,
    public val size: Output<Int>,
    public val type: Output<String>,
    public val volumesPerInstance: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.inputs.InstanceGroupEbsConfigArgs> {
    override fun toJava(): com.pulumi.aws.emr.inputs.InstanceGroupEbsConfigArgs =
        com.pulumi.aws.emr.inputs.InstanceGroupEbsConfigArgs.builder()
            .iops(iops?.applyValue({ args0 -> args0 }))
            .size(size.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .volumesPerInstance(volumesPerInstance?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceGroupEbsConfigArgs].
 */
@PulumiTagMarker
public class InstanceGroupEbsConfigArgsBuilder internal constructor() {
    private var iops: Output<Int>? = null

    private var size: Output<Int>? = null

    private var type: Output<String>? = null

    private var volumesPerInstance: Output<Int>? = null

    /**
     * @param value The number of I/O operations per second (IOPS) that the volume supports.
     */
    @JvmName("jqswnnffqeorcklv")
    public suspend fun iops(`value`: Output<Int>) {
        this.iops = value
    }

    /**
     * @param value The volume size, in gibibytes (GiB). This can be a number from 1 - 1024. If the volume type is EBS-optimized, the minimum value is 10.
     */
    @JvmName("vqjohfrgksxlvecb")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value The volume type. Valid options are 'gp2', 'io1' and 'standard'.
     */
    @JvmName("adivkpoenemmsdoy")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The number of EBS Volumes to attach per instance.
     */
    @JvmName("shlnabbarrnviusb")
    public suspend fun volumesPerInstance(`value`: Output<Int>) {
        this.volumesPerInstance = value
    }

    /**
     * @param value The number of I/O operations per second (IOPS) that the volume supports.
     */
    @JvmName("cptjreevdbclbjlu")
    public suspend fun iops(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iops = mapped
    }

    /**
     * @param value The volume size, in gibibytes (GiB). This can be a number from 1 - 1024. If the volume type is EBS-optimized, the minimum value is 10.
     */
    @JvmName("iuluoqepietpqnyy")
    public suspend fun size(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The volume type. Valid options are 'gp2', 'io1' and 'standard'.
     */
    @JvmName("hjpddwxbyubrxmid")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The number of EBS Volumes to attach per instance.
     */
    @JvmName("ftbdvfgxhovaccsa")
    public suspend fun volumesPerInstance(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumesPerInstance = mapped
    }

    internal fun build(): InstanceGroupEbsConfigArgs = InstanceGroupEbsConfigArgs(
        iops = iops,
        size = size ?: throw PulumiNullFieldException("size"),
        type = type ?: throw PulumiNullFieldException("type"),
        volumesPerInstance = volumesPerInstance,
    )
}
