@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property args List of command line arguments to pass to the bootstrap action script.
 * @property name Name of the bootstrap action.
 * @property path Location of the script to run during a bootstrap action. Can be either a location in Amazon S3 or on a local file system.
 */
public data class ClusterBootstrapAction(
    public val args: List<String>? = null,
    public val name: String,
    public val path: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emr.outputs.ClusterBootstrapAction):
            ClusterBootstrapAction = ClusterBootstrapAction(
            args = javaType.args().map({ args0 -> args0 }),
            name = javaType.name(),
            path = javaType.path(),
        )
    }
}
