@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bidPrice Bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
 * @property bidPriceAsPercentageOfOnDemandPrice Bid price, as a percentage of On-Demand price, for each EC2 Spot instance as defined by `instance_type`. Expressed as a number (for example, 20 specifies 20%). If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
 * @property configurations Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
 * @property ebsConfigs Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
 * @property instanceType EC2 instance type, such as m4.xlarge.
 * @property weightedCapacity Number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in `aws.emr.InstanceFleet`.
 */
public data class ClusterCoreInstanceFleetInstanceTypeConfig(
    public val bidPrice: String? = null,
    public val bidPriceAsPercentageOfOnDemandPrice: Double? = null,
    public val configurations: List<ClusterCoreInstanceFleetInstanceTypeConfigConfiguration>? = null,
    public val ebsConfigs: List<ClusterCoreInstanceFleetInstanceTypeConfigEbsConfig>? = null,
    public val instanceType: String,
    public val weightedCapacity: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.emr.outputs.ClusterCoreInstanceFleetInstanceTypeConfig):
            ClusterCoreInstanceFleetInstanceTypeConfig = ClusterCoreInstanceFleetInstanceTypeConfig(
            bidPrice = javaType.bidPrice().map({ args0 -> args0 }).orElse(null),
            bidPriceAsPercentageOfOnDemandPrice = javaType.bidPriceAsPercentageOfOnDemandPrice().map({ args0 ->
                args0
            }).orElse(null),
            configurations = javaType.configurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.emr.kotlin.outputs.ClusterCoreInstanceFleetInstanceTypeConfigConfiguration.Companion.toKotlin(args0)
                })
            }),
            ebsConfigs = javaType.ebsConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.emr.kotlin.outputs.ClusterCoreInstanceFleetInstanceTypeConfigEbsConfig.Companion.toKotlin(args0)
                })
            }),
            instanceType = javaType.instanceType(),
            weightedCapacity = javaType.weightedCapacity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
