@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property autoscalingPolicy String containing the [EMR Auto Scaling Policy](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-automatic-scaling.html) JSON.
 * @property bidPrice Bid price for each EC2 instance in the instance group, expressed in USD. By setting this attribute, the instance group is being declared as a Spot Instance, and will implicitly create a Spot request. Leave this blank to use On-Demand Instances.
 * @property ebsConfigs Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
 * @property id ID of the cluster.
 * @property instanceCount Target number of instances for the instance group. Must be at least 1. Defaults to 1.
 * @property instanceType EC2 instance type for all instances in the instance group.
 * @property name Friendly name given to the instance group.
 */
public data class ClusterCoreInstanceGroup(
    public val autoscalingPolicy: String? = null,
    public val bidPrice: String? = null,
    public val ebsConfigs: List<ClusterCoreInstanceGroupEbsConfig>? = null,
    public val id: String? = null,
    public val instanceCount: Int? = null,
    public val instanceType: String,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emr.outputs.ClusterCoreInstanceGroup):
            ClusterCoreInstanceGroup = ClusterCoreInstanceGroup(
            autoscalingPolicy = javaType.autoscalingPolicy().map({ args0 -> args0 }).orElse(null),
            bidPrice = javaType.bidPrice().map({ args0 -> args0 }).orElse(null),
            ebsConfigs = javaType.ebsConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.emr.kotlin.outputs.ClusterCoreInstanceGroupEbsConfig.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            instanceCount = javaType.instanceCount().map({ args0 -> args0 }).orElse(null),
            instanceType = javaType.instanceType(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
