@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property id ID of the cluster.
 * @property instanceTypeConfigs Configuration block for instance fleet.
 * @property launchSpecifications Configuration block for launch specification.
 * @property name Friendly name given to the instance fleet.
 * @property provisionedOnDemandCapacity
 * @property provisionedSpotCapacity
 * @property targetOnDemandCapacity Target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
 * @property targetSpotCapacity Target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
 */
public data class ClusterMasterInstanceFleet(
    public val id: String? = null,
    public val instanceTypeConfigs: List<ClusterMasterInstanceFleetInstanceTypeConfig>? = null,
    public val launchSpecifications: ClusterMasterInstanceFleetLaunchSpecifications? = null,
    public val name: String? = null,
    public val provisionedOnDemandCapacity: Int? = null,
    public val provisionedSpotCapacity: Int? = null,
    public val targetOnDemandCapacity: Int? = null,
    public val targetSpotCapacity: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emr.outputs.ClusterMasterInstanceFleet):
            ClusterMasterInstanceFleet = ClusterMasterInstanceFleet(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            instanceTypeConfigs = javaType.instanceTypeConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.emr.kotlin.outputs.ClusterMasterInstanceFleetInstanceTypeConfig.Companion.toKotlin(args0)
                })
            }),
            launchSpecifications = javaType.launchSpecifications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.emr.kotlin.outputs.ClusterMasterInstanceFleetLaunchSpecifications.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisionedOnDemandCapacity = javaType.provisionedOnDemandCapacity().map({ args0 ->
                args0
            }).orElse(null),
            provisionedSpotCapacity = javaType.provisionedSpotCapacity().map({ args0 -> args0 }).orElse(null),
            targetOnDemandCapacity = javaType.targetOnDemandCapacity().map({ args0 -> args0 }).orElse(null),
            targetSpotCapacity = javaType.targetSpotCapacity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
