@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property onDemandSpecifications Configuration block for on demand instances launch specifications.
 * @property spotSpecifications Configuration block for spot instances launch specifications.
 */
public data class ClusterMasterInstanceFleetLaunchSpecifications(
    public val onDemandSpecifications:
    List<ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecification>? = null,
    public val spotSpecifications:
    List<ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecification>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.emr.outputs.ClusterMasterInstanceFleetLaunchSpecifications):
            ClusterMasterInstanceFleetLaunchSpecifications =
            ClusterMasterInstanceFleetLaunchSpecifications(
                onDemandSpecifications = javaType.onDemandSpecifications().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.emr.kotlin.outputs.ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecification.Companion.toKotlin(args0)
                    })
                }),
                spotSpecifications = javaType.spotSpecifications().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.emr.kotlin.outputs.ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecification.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
