@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bidPrice Bid price for each EC2 instance in the instance group, expressed in USD. By setting this attribute, the instance group is being declared as a Spot Instance, and will implicitly create a Spot request. Leave this blank to use On-Demand Instances.
 * @property ebsConfigs Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
 * @property id ID of the cluster.
 * @property instanceCount Target number of instances for the instance group. Must be 1 or 3. Defaults to 1. Launching with multiple master nodes is only supported in EMR version 5.23.0+, and requires this resource's `core_instance_group` to be configured. Public (Internet accessible) instances must be created in VPC subnets that have map public IP on launch enabled. Termination protection is automatically enabled when launched with multiple master nodes and this provider must have the `termination_protection = false` configuration applied before destroying this resource.
 * @property instanceType EC2 instance type for all instances in the instance group.
 * @property name Friendly name given to the instance group.
 */
public data class ClusterMasterInstanceGroup(
    public val bidPrice: String? = null,
    public val ebsConfigs: List<ClusterMasterInstanceGroupEbsConfig>? = null,
    public val id: String? = null,
    public val instanceCount: Int? = null,
    public val instanceType: String,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emr.outputs.ClusterMasterInstanceGroup):
            ClusterMasterInstanceGroup = ClusterMasterInstanceGroup(
            bidPrice = javaType.bidPrice().map({ args0 -> args0 }).orElse(null),
            ebsConfigs = javaType.ebsConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.emr.kotlin.outputs.ClusterMasterInstanceGroupEbsConfig.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            instanceCount = javaType.instanceCount().map({ args0 -> args0 }).orElse(null),
            instanceType = javaType.instanceType(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
