@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property instanceRole Role of the instance in the cluster. Valid Values: `MASTER`, `CORE`, `TASK`.
 * @property placementStrategy EC2 Placement Group strategy associated with instance role. Valid Values: `SPREAD`, `PARTITION`, `CLUSTER`, `NONE`.
 */
public data class ClusterPlacementGroupConfig(
    public val instanceRole: String,
    public val placementStrategy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emr.outputs.ClusterPlacementGroupConfig):
            ClusterPlacementGroupConfig = ClusterPlacementGroupConfig(
            instanceRole = javaType.instanceRole(),
            placementStrategy = javaType.placementStrategy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
