@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property actionOnFailure Action to take if the step fails. Valid values: `TERMINATE_JOB_FLOW`, `TERMINATE_CLUSTER`, `CANCEL_AND_WAIT`, and `CONTINUE`
 * @property hadoopJarStep JAR file used for the step. See below.
 * @property name Name of the step.
 */
public data class ClusterStep(
    public val actionOnFailure: String,
    public val hadoopJarStep: ClusterStepHadoopJarStep,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emr.outputs.ClusterStep): ClusterStep =
            ClusterStep(
                actionOnFailure = javaType.actionOnFailure(),
                hadoopJarStep = javaType.hadoopJarStep().let({ args0 ->
                    com.pulumi.aws.emr.kotlin.outputs.ClusterStepHadoopJarStep.Companion.toKotlin(args0)
                }),
                name = javaType.name(),
            )
    }
}
