@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property application Optional release label application filter. For example, `Spark@2.1.0` or `Spark`.
 * @property prefix Optional release label version prefix filter. For example, `emr-5`.
 */
public data class GetReleaseLabelsFilters(
    public val application: String? = null,
    public val prefix: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emr.outputs.GetReleaseLabelsFilters):
            GetReleaseLabelsFilters = GetReleaseLabelsFilters(
            application = javaType.application().map({ args0 -> args0 }).orElse(null),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
        )
    }
}
