@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property iops The number of I/O operations per second (IOPS) that the volume supports
 * @property size The volume size, in gibibytes (GiB).
 * @property type The volume type. Valid options are `gp2`, `io1`, `standard` and `st1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
 * @property volumesPerInstance The number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1)
 */
public data class InstanceFleetInstanceTypeConfigEbsConfig(
    public val iops: Int? = null,
    public val size: Int,
    public val type: String,
    public val volumesPerInstance: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.emr.outputs.InstanceFleetInstanceTypeConfigEbsConfig):
            InstanceFleetInstanceTypeConfigEbsConfig = InstanceFleetInstanceTypeConfigEbsConfig(
            iops = javaType.iops().map({ args0 -> args0 }).orElse(null),
            size = javaType.size(),
            type = javaType.type(),
            volumesPerInstance = javaType.volumesPerInstance().map({ args0 -> args0 }).orElse(null),
        )
    }
}
