@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property onDemandSpecifications Configuration block for on demand instances launch specifications
 * @property spotSpecifications Configuration block for spot instances launch specifications
 */
public data class InstanceFleetLaunchSpecifications(
    public val onDemandSpecifications: List<InstanceFleetLaunchSpecificationsOnDemandSpecification>? =
        null,
    public val spotSpecifications: List<InstanceFleetLaunchSpecificationsSpotSpecification>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emr.outputs.InstanceFleetLaunchSpecifications):
            InstanceFleetLaunchSpecifications = InstanceFleetLaunchSpecifications(
            onDemandSpecifications = javaType.onDemandSpecifications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.emr.kotlin.outputs.InstanceFleetLaunchSpecificationsOnDemandSpecification.Companion.toKotlin(args0)
                })
            }),
            spotSpecifications = javaType.spotSpecifications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.emr.kotlin.outputs.InstanceFleetLaunchSpecificationsSpotSpecification.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
