@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property allocationStrategy Specifies the strategy to use in launching Spot instance fleets. Currently, the only option is `capacity-optimized` (the default), which launches instances from Spot instance pools with optimal capacity for the number of instances that are launching.
 */
public data class InstanceFleetLaunchSpecificationsOnDemandSpecification(
    public val allocationStrategy: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.emr.outputs.InstanceFleetLaunchSpecificationsOnDemandSpecification):
            InstanceFleetLaunchSpecificationsOnDemandSpecification =
            InstanceFleetLaunchSpecificationsOnDemandSpecification(
                allocationStrategy = javaType.allocationStrategy(),
            )
    }
}
