@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property maximumCapacityUnits The upper boundary of EC2 units. It is measured through VCPU cores or instances for instance groups and measured through units for instance fleets. Managed scaling activities are not allowed beyond this boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
 * @property maximumCoreCapacityUnits The upper boundary of EC2 units for core node type in a cluster. It is measured through VCPU cores or instances for instance groups and measured through units for instance fleets. The core units are not allowed to scale beyond this boundary. The parameter is used to split capacity allocation between core and task nodes.
 * @property maximumOndemandCapacityUnits The upper boundary of On-Demand EC2 units. It is measured through VCPU cores or instances for instance groups and measured through units for instance fleets. The On-Demand units are not allowed to scale beyond this boundary. The parameter is used to split capacity allocation between On-Demand and Spot instances.
 * @property minimumCapacityUnits The lower boundary of EC2 units. It is measured through VCPU cores or instances for instance groups and measured through units for instance fleets. Managed scaling activities are not allowed beyond this boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
 * @property unitType The unit type used for specifying a managed scaling policy. Valid Values: `InstanceFleetUnits` | `Instances` | `VCPU`
 */
public data class ManagedScalingPolicyComputeLimit(
    public val maximumCapacityUnits: Int,
    public val maximumCoreCapacityUnits: Int? = null,
    public val maximumOndemandCapacityUnits: Int? = null,
    public val minimumCapacityUnits: Int,
    public val unitType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emr.outputs.ManagedScalingPolicyComputeLimit):
            ManagedScalingPolicyComputeLimit = ManagedScalingPolicyComputeLimit(
            maximumCapacityUnits = javaType.maximumCapacityUnits(),
            maximumCoreCapacityUnits = javaType.maximumCoreCapacityUnits().map({ args0 -> args0 }).orElse(null),
            maximumOndemandCapacityUnits = javaType.maximumOndemandCapacityUnits().map({ args0 ->
                args0
            }).orElse(null),
            minimumCapacityUnits = javaType.minimumCapacityUnits(),
            unitType = javaType.unitType(),
        )
    }
}
