@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrcontainers.kotlin

import com.pulumi.aws.emrcontainers.EmrcontainersFunctions.getVirtualClusterPlain
import com.pulumi.aws.emrcontainers.kotlin.inputs.GetVirtualClusterPlainArgs
import com.pulumi.aws.emrcontainers.kotlin.inputs.GetVirtualClusterPlainArgsBuilder
import com.pulumi.aws.emrcontainers.kotlin.outputs.GetVirtualClusterResult
import com.pulumi.aws.emrcontainers.kotlin.outputs.GetVirtualClusterResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

public object EmrcontainersFunctions {
    /**
     * Retrieve information about an EMR Containers (EMR on EKS) Virtual Cluster.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.emrcontainers.EmrcontainersFunctions;
     * import com.pulumi.aws.emrcontainers.inputs.GetVirtualClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EmrcontainersFunctions.getVirtualCluster(GetVirtualClusterArgs.builder()
     *             .virtualClusterId("example id")
     *             .build());
     *         ctx.export("name", example.applyValue(getVirtualClusterResult -> getVirtualClusterResult.name()));
     *         ctx.export("arn", example.applyValue(getVirtualClusterResult -> getVirtualClusterResult.arn()));
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getVirtualCluster.
     * @return A collection of values returned by getVirtualCluster.
     */
    public suspend fun getVirtualCluster(argument: GetVirtualClusterPlainArgs):
        GetVirtualClusterResult = toKotlin(getVirtualClusterPlain(argument.toJava()).await())

    /**
     * @see [getVirtualCluster].
     * @param tags Key-value mapping of resource tags.
     * @param virtualClusterId ID of the cluster.
     * @return A collection of values returned by getVirtualCluster.
     */
    public suspend fun getVirtualCluster(tags: Map<String, String>? = null, virtualClusterId: String):
        GetVirtualClusterResult {
        val argument = GetVirtualClusterPlainArgs(
            tags = tags,
            virtualClusterId = virtualClusterId,
        )
        return toKotlin(getVirtualClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualCluster].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;emrcontainers&#46;kotlin&#46;inputs&#46;GetVirtualClusterPlainArgs].
     * @return A collection of values returned by getVirtualCluster.
     */
    public suspend
    fun getVirtualCluster(argument: suspend GetVirtualClusterPlainArgsBuilder.() -> Unit):
        GetVirtualClusterResult {
        val builder = GetVirtualClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getVirtualClusterPlain(builtArgument.toJava()).await())
    }
}
