@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrcontainers.kotlin

import com.pulumi.aws.emrcontainers.VirtualClusterArgs.builder
import com.pulumi.aws.emrcontainers.kotlin.inputs.VirtualClusterContainerProviderArgs
import com.pulumi.aws.emrcontainers.kotlin.inputs.VirtualClusterContainerProviderArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an EMR Containers (EMR on EKS) Virtual Cluster.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emrcontainers.VirtualCluster;
 * import com.pulumi.aws.emrcontainers.VirtualClusterArgs;
 * import com.pulumi.aws.emrcontainers.inputs.VirtualClusterContainerProviderArgs;
 * import com.pulumi.aws.emrcontainers.inputs.VirtualClusterContainerProviderInfoArgs;
 * import com.pulumi.aws.emrcontainers.inputs.VirtualClusterContainerProviderInfoEksInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VirtualCluster("example", VirtualClusterArgs.builder()
 *             .containerProvider(VirtualClusterContainerProviderArgs.builder()
 *                 .id(aws_eks_cluster.example().name())
 *                 .type("EKS")
 *                 .info(VirtualClusterContainerProviderInfoArgs.builder()
 *                     .eksInfo(VirtualClusterContainerProviderInfoEksInfoArgs.builder()
 *                         .namespace("default")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EKS Clusters using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:emrcontainers/virtualCluster:VirtualCluster example a1b2c3d4e5f6g7h8i9j10k11l
 * ```
 * @property containerProvider Configuration block for the container provider associated with your cluster.
 * @property name Name of the virtual cluster.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class VirtualClusterArgs(
    public val containerProvider: Output<VirtualClusterContainerProviderArgs>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.emrcontainers.VirtualClusterArgs> {
    override fun toJava(): com.pulumi.aws.emrcontainers.VirtualClusterArgs =
        com.pulumi.aws.emrcontainers.VirtualClusterArgs.builder()
            .containerProvider(containerProvider?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [VirtualClusterArgs].
 */
@PulumiTagMarker
public class VirtualClusterArgsBuilder internal constructor() {
    private var containerProvider: Output<VirtualClusterContainerProviderArgs>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Configuration block for the container provider associated with your cluster.
     */
    @JvmName("wvlncpavbhbyumoh")
    public suspend fun containerProvider(`value`: Output<VirtualClusterContainerProviderArgs>) {
        this.containerProvider = value
    }

    /**
     * @param value Name of the virtual cluster.
     */
    @JvmName("citjurkbagmfibcg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cpanomyevtajyyhv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for the container provider associated with your cluster.
     */
    @JvmName("mqtwmhtgfmornhsj")
    public suspend fun containerProvider(`value`: VirtualClusterContainerProviderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerProvider = mapped
    }

    /**
     * @param argument Configuration block for the container provider associated with your cluster.
     */
    @JvmName("inqqxuhtvsfairhw")
    public suspend
    fun containerProvider(argument: suspend VirtualClusterContainerProviderArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualClusterContainerProviderArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.containerProvider = mapped
    }

    /**
     * @param value Name of the virtual cluster.
     */
    @JvmName("fqjgywwcubttykxj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("aadtlcxwwohqynjx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("igogcaeveomyiyxd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): VirtualClusterArgs = VirtualClusterArgs(
        containerProvider = containerProvider,
        name = name,
        tags = tags,
    )
}
