@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrcontainers.kotlin.inputs

import com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property configurationOverrides The configuration settings that are used to override defaults configuration.
 * @property executionRoleArn The execution role ARN of the job run.
 * @property jobDriver Specify the driver that the job runs on. Exactly one of the two available job drivers is required, either sparkSqlJobDriver or sparkSubmitJobDriver.
 * @property jobTags The tags assigned to jobs started using the job template.
 * @property releaseLabel The release version of Amazon EMR.
 */
public data class JobTemplateJobTemplateDataArgs(
    public val configurationOverrides: Output<JobTemplateJobTemplateDataConfigurationOverridesArgs>? =
        null,
    public val executionRoleArn: Output<String>,
    public val jobDriver: Output<JobTemplateJobTemplateDataJobDriverArgs>,
    public val jobTags: Output<Map<String, String>>? = null,
    public val releaseLabel: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataArgs> {
    override fun toJava(): com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataArgs =
        com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataArgs.builder()
            .configurationOverrides(
                configurationOverrides?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .executionRoleArn(executionRoleArn.applyValue({ args0 -> args0 }))
            .jobDriver(jobDriver.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jobTags(jobTags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .releaseLabel(releaseLabel.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobTemplateJobTemplateDataArgs].
 */
@PulumiTagMarker
public class JobTemplateJobTemplateDataArgsBuilder internal constructor() {
    private var configurationOverrides: Output<JobTemplateJobTemplateDataConfigurationOverridesArgs>? =
        null

    private var executionRoleArn: Output<String>? = null

    private var jobDriver: Output<JobTemplateJobTemplateDataJobDriverArgs>? = null

    private var jobTags: Output<Map<String, String>>? = null

    private var releaseLabel: Output<String>? = null

    /**
     * @param value The configuration settings that are used to override defaults configuration.
     */
    @JvmName("dcmlsewowwknoodx")
    public suspend
    fun configurationOverrides(`value`: Output<JobTemplateJobTemplateDataConfigurationOverridesArgs>) {
        this.configurationOverrides = value
    }

    /**
     * @param value The execution role ARN of the job run.
     */
    @JvmName("fmfuhwotexqsmhos")
    public suspend fun executionRoleArn(`value`: Output<String>) {
        this.executionRoleArn = value
    }

    /**
     * @param value Specify the driver that the job runs on. Exactly one of the two available job drivers is required, either sparkSqlJobDriver or sparkSubmitJobDriver.
     */
    @JvmName("utnywsiqhyetjvdc")
    public suspend fun jobDriver(`value`: Output<JobTemplateJobTemplateDataJobDriverArgs>) {
        this.jobDriver = value
    }

    /**
     * @param value The tags assigned to jobs started using the job template.
     */
    @JvmName("tcpqjtbmfwxgqkqa")
    public suspend fun jobTags(`value`: Output<Map<String, String>>) {
        this.jobTags = value
    }

    /**
     * @param value The release version of Amazon EMR.
     */
    @JvmName("vblypmsrefkqgwyt")
    public suspend fun releaseLabel(`value`: Output<String>) {
        this.releaseLabel = value
    }

    /**
     * @param value The configuration settings that are used to override defaults configuration.
     */
    @JvmName("wxywmtkniinnthfi")
    public suspend
    fun configurationOverrides(`value`: JobTemplateJobTemplateDataConfigurationOverridesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationOverrides = mapped
    }

    /**
     * @param argument The configuration settings that are used to override defaults configuration.
     */
    @JvmName("jtneoerscxqbxctf")
    public suspend
    fun configurationOverrides(argument: suspend JobTemplateJobTemplateDataConfigurationOverridesArgsBuilder.() -> Unit) {
        val toBeMapped = JobTemplateJobTemplateDataConfigurationOverridesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.configurationOverrides = mapped
    }

    /**
     * @param value The execution role ARN of the job run.
     */
    @JvmName("mpmogmfvcivlufcg")
    public suspend fun executionRoleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.executionRoleArn = mapped
    }

    /**
     * @param value Specify the driver that the job runs on. Exactly one of the two available job drivers is required, either sparkSqlJobDriver or sparkSubmitJobDriver.
     */
    @JvmName("hnyruhpufatjwgrr")
    public suspend fun jobDriver(`value`: JobTemplateJobTemplateDataJobDriverArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobDriver = mapped
    }

    /**
     * @param argument Specify the driver that the job runs on. Exactly one of the two available job drivers is required, either sparkSqlJobDriver or sparkSubmitJobDriver.
     */
    @JvmName("idskvxrvnptcfawk")
    public suspend
    fun jobDriver(argument: suspend JobTemplateJobTemplateDataJobDriverArgsBuilder.() -> Unit) {
        val toBeMapped = JobTemplateJobTemplateDataJobDriverArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.jobDriver = mapped
    }

    /**
     * @param value The tags assigned to jobs started using the job template.
     */
    @JvmName("bfsouhlebrervhwd")
    public suspend fun jobTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobTags = mapped
    }

    /**
     * @param values The tags assigned to jobs started using the job template.
     */
    @JvmName("qfqyinbcipwvxnyb")
    public fun jobTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobTags = mapped
    }

    /**
     * @param value The release version of Amazon EMR.
     */
    @JvmName("iiuoebumnfqakvqn")
    public suspend fun releaseLabel(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.releaseLabel = mapped
    }

    internal fun build(): JobTemplateJobTemplateDataArgs = JobTemplateJobTemplateDataArgs(
        configurationOverrides = configurationOverrides,
        executionRoleArn = executionRoleArn ?: throw PulumiNullFieldException("executionRoleArn"),
        jobDriver = jobDriver ?: throw PulumiNullFieldException("jobDriver"),
        jobTags = jobTags,
        releaseLabel = releaseLabel ?: throw PulumiNullFieldException("releaseLabel"),
    )
}
