@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrcontainers.kotlin.inputs

import com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataConfigurationOverridesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property applicationConfigurations The configurations for the application running by the job run.
 * @property monitoringConfiguration The configurations for monitoring.
 */
public data class JobTemplateJobTemplateDataConfigurationOverridesArgs(
    public val applicationConfigurations:
    Output<List<JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationArgs>>? =
        null,
    public val monitoringConfiguration:
    Output<JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataConfigurationOverridesArgs> {
    override fun toJava():
        com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataConfigurationOverridesArgs =
        com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataConfigurationOverridesArgs.builder()
            .applicationConfigurations(
                applicationConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .monitoringConfiguration(
                monitoringConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [JobTemplateJobTemplateDataConfigurationOverridesArgs].
 */
@PulumiTagMarker
public class JobTemplateJobTemplateDataConfigurationOverridesArgsBuilder internal constructor() {
    private var applicationConfigurations:
        Output<List<JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationArgs>>? =
        null

    private var monitoringConfiguration:
        Output<JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationArgs>? = null

    /**
     * @param value The configurations for the application running by the job run.
     */
    @JvmName("ciykyuvcvbwadbbr")
    public suspend
    fun applicationConfigurations(`value`: Output<List<JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationArgs>>) {
        this.applicationConfigurations = value
    }

    @JvmName("amaotafannocnbrt")
    public suspend fun applicationConfigurations(
        vararg
        values: Output<JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationArgs>,
    ) {
        this.applicationConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The configurations for the application running by the job run.
     */
    @JvmName("wajkwyjxbiptdmbd")
    public suspend
    fun applicationConfigurations(values: List<Output<JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationArgs>>) {
        this.applicationConfigurations = Output.all(values)
    }

    /**
     * @param value The configurations for monitoring.
     */
    @JvmName("stebpirtjehjcqsa")
    public suspend
    fun monitoringConfiguration(`value`: Output<JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationArgs>) {
        this.monitoringConfiguration = value
    }

    /**
     * @param value The configurations for the application running by the job run.
     */
    @JvmName("tqisggvkjljtpwxw")
    public suspend
    fun applicationConfigurations(`value`: List<JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationConfigurations = mapped
    }

    /**
     * @param argument The configurations for the application running by the job run.
     */
    @JvmName("tkqkfbukbhugtmju")
    public suspend
    fun applicationConfigurations(argument: List<suspend JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.applicationConfigurations = mapped
    }

    /**
     * @param argument The configurations for the application running by the job run.
     */
    @JvmName("rtuvfpapmbraquyx")
    public suspend fun applicationConfigurations(
        vararg
        argument: suspend JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.applicationConfigurations = mapped
    }

    /**
     * @param argument The configurations for the application running by the job run.
     */
    @JvmName("bumshdahspbjcpet")
    public suspend
    fun applicationConfigurations(argument: suspend JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.applicationConfigurations = mapped
    }

    /**
     * @param values The configurations for the application running by the job run.
     */
    @JvmName("uhwqkfbbkxhomewn")
    public suspend fun applicationConfigurations(
        vararg
        values: JobTemplateJobTemplateDataConfigurationOverridesApplicationConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationConfigurations = mapped
    }

    /**
     * @param value The configurations for monitoring.
     */
    @JvmName("ulxyhjlyuwfolcso")
    public suspend
    fun monitoringConfiguration(`value`: JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoringConfiguration = mapped
    }

    /**
     * @param argument The configurations for monitoring.
     */
    @JvmName("nomldbifkdewbcpt")
    public suspend
    fun monitoringConfiguration(argument: suspend JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.monitoringConfiguration = mapped
    }

    internal fun build(): JobTemplateJobTemplateDataConfigurationOverridesArgs =
        JobTemplateJobTemplateDataConfigurationOverridesArgs(
            applicationConfigurations = applicationConfigurations,
            monitoringConfiguration = monitoringConfiguration,
        )
}
