@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrcontainers.kotlin.inputs

import com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cloudWatchMonitoringConfiguration Monitoring configurations for CloudWatch.
 * @property persistentAppUi Monitoring configurations for the persistent application UI.
 * @property s3MonitoringConfiguration Amazon S3 configuration for monitoring log publishing.
 */
public data class JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationArgs(
    public val cloudWatchMonitoringConfiguration:
    Output<JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationCloudWatchMonitoringConfigurationArgs>? =
        null,
    public val persistentAppUi: Output<String>? = null,
    public val s3MonitoringConfiguration:
    Output<JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationS3MonitoringConfigurationArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationArgs =
        com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationArgs.builder()
            .cloudWatchMonitoringConfiguration(
                cloudWatchMonitoringConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .persistentAppUi(persistentAppUi?.applyValue({ args0 -> args0 }))
            .s3MonitoringConfiguration(
                s3MonitoringConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationArgs].
 */
@PulumiTagMarker
public class JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationArgsBuilder
internal constructor() {
    private var cloudWatchMonitoringConfiguration:
        Output<JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationCloudWatchMonitoringConfigurationArgs>? =
        null

    private var persistentAppUi: Output<String>? = null

    private var s3MonitoringConfiguration:
        Output<JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationS3MonitoringConfigurationArgs>? =
        null

    /**
     * @param value Monitoring configurations for CloudWatch.
     */
    @JvmName("uuweebfrngbbclam")
    public suspend
    fun cloudWatchMonitoringConfiguration(`value`: Output<JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationCloudWatchMonitoringConfigurationArgs>) {
        this.cloudWatchMonitoringConfiguration = value
    }

    /**
     * @param value Monitoring configurations for the persistent application UI.
     */
    @JvmName("lpjcekryxxadytat")
    public suspend fun persistentAppUi(`value`: Output<String>) {
        this.persistentAppUi = value
    }

    /**
     * @param value Amazon S3 configuration for monitoring log publishing.
     */
    @JvmName("ffcatjoawlddenhg")
    public suspend
    fun s3MonitoringConfiguration(`value`: Output<JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationS3MonitoringConfigurationArgs>) {
        this.s3MonitoringConfiguration = value
    }

    /**
     * @param value Monitoring configurations for CloudWatch.
     */
    @JvmName("qudbywipooyhhlgn")
    public suspend
    fun cloudWatchMonitoringConfiguration(`value`: JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationCloudWatchMonitoringConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudWatchMonitoringConfiguration = mapped
    }

    /**
     * @param argument Monitoring configurations for CloudWatch.
     */
    @JvmName("acmlgxrocvxeygyw")
    public suspend
    fun cloudWatchMonitoringConfiguration(argument: suspend JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationCloudWatchMonitoringConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationCloudWatchMonitoringConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cloudWatchMonitoringConfiguration = mapped
    }

    /**
     * @param value Monitoring configurations for the persistent application UI.
     */
    @JvmName("ylsmtuvwrdaahrap")
    public suspend fun persistentAppUi(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.persistentAppUi = mapped
    }

    /**
     * @param value Amazon S3 configuration for monitoring log publishing.
     */
    @JvmName("lfsggqwttludacwb")
    public suspend
    fun s3MonitoringConfiguration(`value`: JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationS3MonitoringConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3MonitoringConfiguration = mapped
    }

    /**
     * @param argument Amazon S3 configuration for monitoring log publishing.
     */
    @JvmName("otlbxdqpcswjrdyc")
    public suspend
    fun s3MonitoringConfiguration(argument: suspend JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationS3MonitoringConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationS3MonitoringConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3MonitoringConfiguration = mapped
    }

    internal fun build(): JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationArgs =
        JobTemplateJobTemplateDataConfigurationOverridesMonitoringConfigurationArgs(
            cloudWatchMonitoringConfiguration = cloudWatchMonitoringConfiguration,
            persistentAppUi = persistentAppUi,
            s3MonitoringConfiguration = s3MonitoringConfiguration,
        )
}
