@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrcontainers.kotlin.inputs

import com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property entryPoint The SQL file to be executed.
 * @property sparkSqlParameters The Spark parameters to be included in the Spark SQL command.
 */
public data class JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgs(
    public val entryPoint: Output<String>? = null,
    public val sparkSqlParameters: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgs> {
    override fun toJava():
        com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgs =
        com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgs.builder()
            .entryPoint(entryPoint?.applyValue({ args0 -> args0 }))
            .sparkSqlParameters(sparkSqlParameters?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgs].
 */
@PulumiTagMarker
public class JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgsBuilder internal constructor() {
    private var entryPoint: Output<String>? = null

    private var sparkSqlParameters: Output<String>? = null

    /**
     * @param value The SQL file to be executed.
     */
    @JvmName("gxgjxblntfveklph")
    public suspend fun entryPoint(`value`: Output<String>) {
        this.entryPoint = value
    }

    /**
     * @param value The Spark parameters to be included in the Spark SQL command.
     */
    @JvmName("tlghthihgarcbudf")
    public suspend fun sparkSqlParameters(`value`: Output<String>) {
        this.sparkSqlParameters = value
    }

    /**
     * @param value The SQL file to be executed.
     */
    @JvmName("uvyladionnhlnnms")
    public suspend fun entryPoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entryPoint = mapped
    }

    /**
     * @param value The Spark parameters to be included in the Spark SQL command.
     */
    @JvmName("ppvceaddvfkhuald")
    public suspend fun sparkSqlParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sparkSqlParameters = mapped
    }

    internal fun build(): JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgs =
        JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgs(
            entryPoint = entryPoint,
            sparkSqlParameters = sparkSqlParameters,
        )
}
