@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrcontainers.kotlin.inputs

import com.pulumi.aws.emrcontainers.inputs.VirtualClusterContainerProviderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property id The name of the container provider that is running your EMR Containers cluster
 * @property info Nested list containing information about the configuration of the container provider
 * @property type The type of the container provider
 */
public data class VirtualClusterContainerProviderArgs(
    public val id: Output<String>,
    public val info: Output<VirtualClusterContainerProviderInfoArgs>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.emrcontainers.inputs.VirtualClusterContainerProviderArgs> {
    override fun toJava(): com.pulumi.aws.emrcontainers.inputs.VirtualClusterContainerProviderArgs =
        com.pulumi.aws.emrcontainers.inputs.VirtualClusterContainerProviderArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .info(info.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualClusterContainerProviderArgs].
 */
@PulumiTagMarker
public class VirtualClusterContainerProviderArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var info: Output<VirtualClusterContainerProviderInfoArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value The name of the container provider that is running your EMR Containers cluster
     */
    @JvmName("qosmttpvxnnslqel")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Nested list containing information about the configuration of the container provider
     */
    @JvmName("bdoxifatjgfitjff")
    public suspend fun info(`value`: Output<VirtualClusterContainerProviderInfoArgs>) {
        this.info = value
    }

    /**
     * @param value The type of the container provider
     */
    @JvmName("lbujngppkpmgubwi")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of the container provider that is running your EMR Containers cluster
     */
    @JvmName("utehmnhbbpjqldre")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Nested list containing information about the configuration of the container provider
     */
    @JvmName("fcwvbpanrjqdavmv")
    public suspend fun info(`value`: VirtualClusterContainerProviderInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.info = mapped
    }

    /**
     * @param argument Nested list containing information about the configuration of the container provider
     */
    @JvmName("gwyorefmlsgemwde")
    public suspend
    fun info(argument: suspend VirtualClusterContainerProviderInfoArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualClusterContainerProviderInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.info = mapped
    }

    /**
     * @param value The type of the container provider
     */
    @JvmName("bnblxljftmyrtnrn")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): VirtualClusterContainerProviderArgs = VirtualClusterContainerProviderArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        info = info ?: throw PulumiNullFieldException("info"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
