@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrcontainers.kotlin.inputs

import com.pulumi.aws.emrcontainers.inputs.VirtualClusterContainerProviderInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property eksInfo Nested list containing EKS-specific information about the cluster where the EMR Containers cluster is running
 */
public data class VirtualClusterContainerProviderInfoArgs(
    public val eksInfo: Output<VirtualClusterContainerProviderInfoEksInfoArgs>,
) : ConvertibleToJava<com.pulumi.aws.emrcontainers.inputs.VirtualClusterContainerProviderInfoArgs> {
    override fun toJava(): com.pulumi.aws.emrcontainers.inputs.VirtualClusterContainerProviderInfoArgs =
        com.pulumi.aws.emrcontainers.inputs.VirtualClusterContainerProviderInfoArgs.builder()
            .eksInfo(eksInfo.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualClusterContainerProviderInfoArgs].
 */
@PulumiTagMarker
public class VirtualClusterContainerProviderInfoArgsBuilder internal constructor() {
    private var eksInfo: Output<VirtualClusterContainerProviderInfoEksInfoArgs>? = null

    /**
     * @param value Nested list containing EKS-specific information about the cluster where the EMR Containers cluster is running
     */
    @JvmName("jwpwaisngjmysskv")
    public suspend fun eksInfo(`value`: Output<VirtualClusterContainerProviderInfoEksInfoArgs>) {
        this.eksInfo = value
    }

    /**
     * @param value Nested list containing EKS-specific information about the cluster where the EMR Containers cluster is running
     */
    @JvmName("hiaecogikbxnacei")
    public suspend fun eksInfo(`value`: VirtualClusterContainerProviderInfoEksInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eksInfo = mapped
    }

    /**
     * @param argument Nested list containing EKS-specific information about the cluster where the EMR Containers cluster is running
     */
    @JvmName("gwrglqvpjgcckmyg")
    public suspend
    fun eksInfo(argument: suspend VirtualClusterContainerProviderInfoEksInfoArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualClusterContainerProviderInfoEksInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.eksInfo = mapped
    }

    internal fun build(): VirtualClusterContainerProviderInfoArgs =
        VirtualClusterContainerProviderInfoArgs(
            eksInfo = eksInfo ?: throw PulumiNullFieldException("eksInfo"),
        )
}
