@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrcontainers.kotlin.inputs

import com.pulumi.aws.emrcontainers.inputs.VirtualClusterContainerProviderInfoEksInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property namespace The namespace where the EMR Containers cluster is running
 */
public data class VirtualClusterContainerProviderInfoEksInfoArgs(
    public val namespace: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.emrcontainers.inputs.VirtualClusterContainerProviderInfoEksInfoArgs> {
    override fun toJava():
        com.pulumi.aws.emrcontainers.inputs.VirtualClusterContainerProviderInfoEksInfoArgs =
        com.pulumi.aws.emrcontainers.inputs.VirtualClusterContainerProviderInfoEksInfoArgs.builder()
            .namespace(namespace?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualClusterContainerProviderInfoEksInfoArgs].
 */
@PulumiTagMarker
public class VirtualClusterContainerProviderInfoEksInfoArgsBuilder internal constructor() {
    private var namespace: Output<String>? = null

    /**
     * @param value The namespace where the EMR Containers cluster is running
     */
    @JvmName("wyxranbeairrlnoe")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value The namespace where the EMR Containers cluster is running
     */
    @JvmName("vokrydjskywjlsim")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    internal fun build(): VirtualClusterContainerProviderInfoEksInfoArgs =
        VirtualClusterContainerProviderInfoEksInfoArgs(
            namespace = namespace,
        )
}
