@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrcontainers.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property id The name of the container provider that is running your EMR Containers cluster
 * @property infos Nested list containing information about the configuration of the container provider
 * @property type The type of the container provider
 */
public data class GetVirtualClusterContainerProvider(
    public val id: String,
    public val infos: List<GetVirtualClusterContainerProviderInfo>,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.emrcontainers.outputs.GetVirtualClusterContainerProvider):
            GetVirtualClusterContainerProvider = GetVirtualClusterContainerProvider(
            id = javaType.id(),
            infos = javaType.infos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.emrcontainers.kotlin.outputs.GetVirtualClusterContainerProviderInfo.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
