@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrcontainers.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getVirtualCluster.
 * @property arn ARN of the cluster.
 * @property containerProviders Nested attribute containing information about the underlying container provider (EKS cluster) for your EMR Containers cluster.
 * @property createdAt Unix epoch time stamp in seconds for when the cluster was created.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name Name of the cluster.
 * @property state Status of the EKS cluster. One of `RUNNING`, `TERMINATING`, `TERMINATED`, `ARRESTED`.
 * @property tags Key-value mapping of resource tags.
 * @property virtualClusterId
 */
public data class GetVirtualClusterResult(
    public val arn: String,
    public val containerProviders: List<GetVirtualClusterContainerProvider>,
    public val createdAt: String,
    public val id: String,
    public val name: String,
    public val state: String,
    public val tags: Map<String, String>,
    public val virtualClusterId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emrcontainers.outputs.GetVirtualClusterResult):
            GetVirtualClusterResult = GetVirtualClusterResult(
            arn = javaType.arn(),
            containerProviders = javaType.containerProviders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.emrcontainers.kotlin.outputs.GetVirtualClusterContainerProvider.Companion.toKotlin(args0)
                })
            }),
            createdAt = javaType.createdAt(),
            id = javaType.id(),
            name = javaType.name(),
            state = javaType.state(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            virtualClusterId = javaType.virtualClusterId(),
        )
    }
}
