@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrcontainers.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property configurationOverrides The configuration settings that are used to override defaults configuration.
 * @property executionRoleArn The execution role ARN of the job run.
 * @property jobDriver Specify the driver that the job runs on. Exactly one of the two available job drivers is required, either sparkSqlJobDriver or sparkSubmitJobDriver.
 * @property jobTags The tags assigned to jobs started using the job template.
 * @property releaseLabel The release version of Amazon EMR.
 */
public data class JobTemplateJobTemplateData(
    public val configurationOverrides: JobTemplateJobTemplateDataConfigurationOverrides? = null,
    public val executionRoleArn: String,
    public val jobDriver: JobTemplateJobTemplateDataJobDriver,
    public val jobTags: Map<String, String>? = null,
    public val releaseLabel: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emrcontainers.outputs.JobTemplateJobTemplateData):
            JobTemplateJobTemplateData = JobTemplateJobTemplateData(
            configurationOverrides = javaType.configurationOverrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.emrcontainers.kotlin.outputs.JobTemplateJobTemplateDataConfigurationOverrides.Companion.toKotlin(args0)
                })
            }).orElse(null),
            executionRoleArn = javaType.executionRoleArn(),
            jobDriver = javaType.jobDriver().let({ args0 ->
                com.pulumi.aws.emrcontainers.kotlin.outputs.JobTemplateJobTemplateDataJobDriver.Companion.toKotlin(args0)
            }),
            jobTags = javaType.jobTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            releaseLabel = javaType.releaseLabel(),
        )
    }
}
