@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrcontainers.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The name of the container provider that is running your EMR Containers cluster
 * @property info Nested list containing information about the configuration of the container provider
 * @property type The type of the container provider
 */
public data class VirtualClusterContainerProvider(
    public val id: String,
    public val info: VirtualClusterContainerProviderInfo,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.emrcontainers.outputs.VirtualClusterContainerProvider):
            VirtualClusterContainerProvider = VirtualClusterContainerProvider(
            id = javaType.id(),
            info = javaType.info().let({ args0 ->
                com.pulumi.aws.emrcontainers.kotlin.outputs.VirtualClusterContainerProviderInfo.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
