@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrserverless.kotlin

import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationAutoStartConfiguration
import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationAutoStopConfiguration
import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationImageConfiguration
import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationInitialCapacity
import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationMaximumCapacity
import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationNetworkConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationAutoStartConfiguration.Companion.toKotlin as applicationAutoStartConfigurationToKotlin
import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationAutoStopConfiguration.Companion.toKotlin as applicationAutoStopConfigurationToKotlin
import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationImageConfiguration.Companion.toKotlin as applicationImageConfigurationToKotlin
import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationInitialCapacity.Companion.toKotlin as applicationInitialCapacityToKotlin
import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationMaximumCapacity.Companion.toKotlin as applicationMaximumCapacityToKotlin
import com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationNetworkConfiguration.Companion.toKotlin as applicationNetworkConfigurationToKotlin

/**
 * Builder for [Application].
 */
@PulumiTagMarker
public class ApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationArgs = ApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationArgsBuilder.() -> Unit) {
        val builder = ApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Application {
        val builtJavaResource = com.pulumi.aws.emrserverless.Application(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Application(builtJavaResource)
    }
}

/**
 * Manages an EMR Serverless Application.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emrserverless.Application;
 * import com.pulumi.aws.emrserverless.ApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Application("example", ApplicationArgs.builder()
 *             .releaseLabel("emr-6.6.0")
 *             .type("hive")
 *             .build());
 *     }
 * }
 * ```
 * ### Initial Capacity Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emrserverless.Application;
 * import com.pulumi.aws.emrserverless.ApplicationArgs;
 * import com.pulumi.aws.emrserverless.inputs.ApplicationInitialCapacityArgs;
 * import com.pulumi.aws.emrserverless.inputs.ApplicationInitialCapacityInitialCapacityConfigArgs;
 * import com.pulumi.aws.emrserverless.inputs.ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Application("example", ApplicationArgs.builder()
 *             .initialCapacities(ApplicationInitialCapacityArgs.builder()
 *                 .initialCapacityConfig(ApplicationInitialCapacityInitialCapacityConfigArgs.builder()
 *                     .workerConfiguration(ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgs.builder()
 *                         .cpu("2 vCPU")
 *                         .memory("10 GB")
 *                         .build())
 *                     .workerCount(1)
 *                     .build())
 *                 .initialCapacityType("HiveDriver")
 *                 .build())
 *             .releaseLabel("emr-6.6.0")
 *             .type("hive")
 *             .build());
 *     }
 * }
 * ```
 * ### Maximum Capacity Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emrserverless.Application;
 * import com.pulumi.aws.emrserverless.ApplicationArgs;
 * import com.pulumi.aws.emrserverless.inputs.ApplicationMaximumCapacityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Application("example", ApplicationArgs.builder()
 *             .maximumCapacity(ApplicationMaximumCapacityArgs.builder()
 *                 .cpu("2 vCPU")
 *                 .memory("10 GB")
 *                 .build())
 *             .releaseLabel("emr-6.6.0")
 *             .type("hive")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EMR Severless applications using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:emrserverless/application:Application example id
 * ```
 *
 */
public class Application internal constructor(
    override val javaResource: com.pulumi.aws.emrserverless.Application,
) : KotlinCustomResource(javaResource, ApplicationMapper) {
    /**
     * The CPU architecture of an application. Valid values are `ARM64` or `X86_64`. Default value is `X86_64`.
     */
    public val architecture: Output<String>?
        get() = javaResource.architecture().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the cluster.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The configuration for an application to automatically start on job submission.
     */
    public val autoStartConfiguration: Output<ApplicationAutoStartConfiguration>
        get() = javaResource.autoStartConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationAutoStartConfigurationToKotlin(args0)
            })
        })

    /**
     * The configuration for an application to automatically stop after a certain amount of time being idle.
     */
    public val autoStopConfiguration: Output<ApplicationAutoStopConfiguration>
        get() = javaResource.autoStopConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationAutoStopConfigurationToKotlin(args0)
            })
        })

    /**
     * The image configuration applied to all worker types.
     */
    public val imageConfiguration: Output<ApplicationImageConfiguration>
        get() = javaResource.imageConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationImageConfigurationToKotlin(args0)
            })
        })

    /**
     * The capacity to initialize when the application is created.
     */
    public val initialCapacities: Output<List<ApplicationInitialCapacity>>?
        get() = javaResource.initialCapacities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationInitialCapacityToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The maximum capacity to allocate when the application is created. This is cumulative across all workers at any given point in time, not just when an application is created. No new resources will be created once any one of the defined limits is hit.
     */
    public val maximumCapacity: Output<ApplicationMaximumCapacity>
        get() = javaResource.maximumCapacity().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationMaximumCapacityToKotlin(args0)
            })
        })

    /**
     * The name of the application.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The network configuration for customer VPC connectivity.
     */
    public val networkConfiguration: Output<ApplicationNetworkConfiguration>?
        get() = javaResource.networkConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> applicationNetworkConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The EMR release version associated with the application.
     */
    public val releaseLabel: Output<String>
        get() = javaResource.releaseLabel().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The type of application you want to start, such as `spark` or `hive`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ApplicationMapper : ResourceMapper<Application> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.emrserverless.Application::class == javaResource::class

    override fun map(javaResource: Resource): Application = Application(
        javaResource as
            com.pulumi.aws.emrserverless.Application,
    )
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Application].
 */
public suspend fun application(name: String, block: suspend ApplicationResourceBuilder.() -> Unit):
    Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 */
public fun application(name: String): Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
